package org.apache.james.util;

/** Utility to extract different parts of class' name.
 *
 * @author Alexander Zhukov <zhukov@ukrpost.net>
 */
public class ClassnameUtil {
    /** Prints class name without package name.
     *
     * As in unix basename command:
     * basename /home/zhukov/james.jar
     * gives james.jar
     *
     * @param clazz - class to basename
     * @return classes basename
     */
    public static final String getClassBasename(Class clazz) {
        String name = clazz.getName();
        String packagename = clazz.getPackage().getName();
        if ( packagename == null || "".equals(packagename) )
            return name;

        return name.substring(packagename.length()+1);
    }
}
