package org.apache.james.util;

import org.apache.commons.lang.StringEscapeUtils;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

/** Useful methods to work with javax.naming.directory.*.
 *
 * @author Alexander Zhukov <zhukov@ukrpost.net>
 */
public class NamingUtils {
    public static StringBuffer attributesToStringBuffer(Attributes attrs) {
        StringBuffer out = new StringBuffer();
        if ( attrs == null )
            return out;

        NamingEnumeration en = attrs.getAll();
        out.append('[');
        while (en.hasMoreElements()) {
            Attribute attr = (Attribute) en.nextElement();
            if ( attr == null ) {
                out.append("null");
                break;
            }
            String id = String.valueOf(attr.getID());
            out.append('[').append(id).append(':');
            try {
                NamingEnumeration valuesEn = attr.getAll();
                for (int i=0;valuesEn.hasMoreElements();i++) {
                    Object o = (Object) valuesEn.nextElement();
                    String value = StringEscapeUtils.escapeJava(String.valueOf(o));
                    if ( i > 0 )
                        out.append(", ");
                    out.append(value);
                }
            } catch (NamingException e) {
                out.append(e.getMessage());
            } finally {
                out.append(']');
            }
        }
        out.append(']');
        return out;
    }

    public static String attributesToString(Attributes attrs) {
        return attributesToStringBuffer(attrs).toString();
    }
}
