package org.apache.james.userrepository;

import org.apache.james.services.DirectoryUser;
import org.apache.mailet.MailAddress;

import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

/** Implementation of DirectoryUser interface.
 *
 * @author Alexander Zhukov <zhukov@ukrpost.net>
 */
public class DirectoryUserImpl implements DirectoryUser {


    public Password getPassword() {
        return password;
    }

    public void setPassword(Password password) {
        this.password = password;
    }

    private Password password = null;

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    private String username = null;

    public DirectoryUserImpl(String username, Attributes attrs) {
        this.attrs = attrs;
        //todo: make userPassword configurable depends on directory type
        String passwdAttr = getAttribute("userPassword");
        System.out.println("userpasswd: "+passwdAttr);
        password = new Password(passwdAttr, null, true);
    }

    private Attributes attrs = null;

    public Attributes getAttributes() {
        return attrs;
    }

    public String getAttribute(String name) {
        try {
            Attribute attr = getAttributes().get(name);
            if ( attr == null )
                return null;
            Object value = attr.get();
            if ( value == null )
                return null;

            //userPassword is often returned as byte array so we convert it to String ignoring the eights bit
            //i think ignoring here is ok if you dont override this method :)
            if ( value instanceof byte[] )
                return new String((byte[])value, "us-ascii");
            return value.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUserName() {
        return null;
    }

    public boolean verifyPassword(String pass) {
        return password.equals(pass);
    }

    public boolean setPassword(String newPass) {
        setPassword(new Password(newPass));
        return true;
    }


    public void setForwarding(boolean forward) {
    }

    public boolean getForwarding() {
        return false;
    }

    public boolean setForwardingDestination(MailAddress address) {
        return false;
    }

    public MailAddress getForwardingDestination() {
        return null;
    }

    public void setAliasing(boolean alias) {
    }

    public boolean getAliasing() {
        return false;
    }

    public boolean setAlias(String address) {
        return false;
    }

    public String getAlias() {
        return null;
    }
}
