#
# Shorewall version 3.4 - Action Template
#
# /etc/shorewall/action.template
#
#	This file is a template for files with names of the form
#	/etc/shorewall/action.<action-name> where <action> is an
#	ACTION defined in /etc/shorewall/actions.
#
#	To define a new action:
#
#	1. Add the <action name> to /etc/shorewall/actions
#	2. Copy this file to /etc/shorewall/action.<action name>
#	3. Add the desired rules to that file.
#
#	Please see http://shorewall.net/Actions.html for additional
#	information.
#
# Columns are:
#
#
#	TARGET		ACCEPT, DROP, REJECT, LOG, QUEUE, CONTINUEa <macro>
#			or a previously-defined <action>
#
#				ACCEPT	 -- allow the connection request
#				DROP	 -- ignore the request
#				REJECT	 -- disallow the request and return an
#					    icmp-unreachable or an RST packet.
#				LOG	 -- Simply log the packet and continue.
#				QUEUE	 -- Queue the packet to a user-space
#					    application such as p2pwall.
#				CONTINUE -- Discontinue processing this action
#					    and return to the point where the
#					    action was invoked.
#				<action> -- An <action> defined in
#					    /etc/shorewall/actions.
#					    The <action> must appear in that
#					    file BEFORE the one being defined
#					    in this file.
#				<macro>	 -- The name of a macro defined in a
#					    file named macro.<macro-name>. If
#					    the macro accepts an action
#					    parameter (Look at the macro
#					    source to see if it has PARAM in
#					    the TARGET column) then the macro
#					    name is followed by "/" and the
#					    action (ACCEPT, DROP, REJECT, ...)
#					    to be substituted for the
#					    parameter. Example: FTP/ACCEPT.
#
#			The TARGET may optionally be followed
#			by ":" and a syslog log level (e.g, REJECT:info or
#			ACCEPT:debugging). This causes the packet to be
#			logged at the specified level.
#
#			The special log level 'none' does not result in logging
#			but rather exempts the rule from being overridden by a
#			non-forcing log level when the action is invoked.
#
#			You may also specify ULOG (must be in upper case) as a
#			log level.This will log to the ULOG target for routing
#			to a separate log through use of ulogd
#			(http://www.gnumonks.org/projects/ulogd).
#
#			Actions specifying logging may be followed by a
#			log tag (a string of alphanumeric characters)
#			are appended to the string generated by the
#			LOGPREFIX (in /etc/shorewall/shorewall.conf).
#
#			Example: ACCEPT:info:ftp would include 'ftp '
#			at the end of the log prefix generated by the
#			LOGPREFIX setting.
#
#	SOURCE		Source hosts to which the rule applies.
#			A comma-separated list of subnets
#			and/or hosts. Hosts may be specified by IP or MAC
#			address; mac addresses must begin with "~" and must use
#			"-" as a separator.
#
#			192.168.2.2		Host 192.168.2.2
#
#			155.186.235.0/24	Subnet 155.186.235.0/24
#
#			10.0.0.4-10.0.0.9	Range of IP addresses; your
#						kernel and iptables must have
#						iprange match support.
#
#			+remote			The name of an ipset prefaced
#						by "+". Your kernel and
#						iptables must have set match
#						support
#
#			+remote[4]		The name of the ipset may
#						followed by a number of
#						levels of ipset bindings
#						enclosed in square brackets.
#
#			192.168.1.1,192.168.1.2
#						Hosts 192.168.1.1 and
#						192.168.1.2.
#			~00-A0-C9-15-39-78	Host with
#						MAC address 00:A0:C9:15:39:78.
#
#			Alternatively, clients may be specified by interface
#			name. For example, eth1 specifies a
#			client that communicates with the firewall system
#			through eth1. This may be optionally followed by
#			another colon (":") and an IP/MAC/subnet address
#			as described above (e.g., eth1:192.168.1.5).
#
#	DEST		Location of destination host. Same as above with
#			the exception that MAC addresses are not allowed and
#			that you cannot specify an ipset name in both the
#			SOURCE and DEST columns.
#
#	PROTO		Protocol - Must be "tcp", "tcp:syn", "udp", "icmp",
#			"ipp2p", "ipp2p:udp", "ipp2p:all" a number, or "all".
#                       "ipp2p*" requires ipp2p match support in your kernel
#                       and iptables.
#
#			"tcp:syn" implies "tcp" plus the SYN flag must be
#			set and the RST,ACK and FIN flags must be reset.
#
#	DEST PORT(S)	Destination Ports. A comma-separated list of Port
#			names (from /etc/services), port numbers or port
#			ranges; if the protocol is "icmp", this column is
#			interpreted as the destination icmp-type(s).
#
#			A port range is expressed as <low port>:<high port>.
#
#			This column is ignored if PROTOCOL = all but must be
#			entered if any of the following fields are supplied.
#			In that case, it is suggested that this field contain
#			 "-"
#
#			If your kernel contains multi-port match support, then
#			only a single Netfilter rule will be generated if in
#			this list and the CLIENT PORT(S) list below:
#			1. There are 15 or less ports listed.
#			2. No port ranges are included.
#			Otherwise, a separate rule will be generated for each
#			port.
#
#	SOURCE PORT(S)	(Optional) Port(s) used by the client. If omitted,
#			any source port is acceptable. Specified as a comma-
#			separated list of port names, port numbers or port
#			ranges.
#
#			If you don't want to restrict client ports but need to
#			specify an ADDRESS in the next column, then place "-"
#			in this column.
#
#			If your kernel contains multi-port match support, then
#			only a single Netfilter rule will be generated if in
#			this list and the DEST PORT(S) list above:
#			1. There are 15 or less ports listed.
#			2. No port ranges are included.
#			Otherwise, a separate rule will be generated for each
#			port.
#
#	RATE LIMIT	You may rate-limit the rule by placing a value in
#			this column:
#
#				<rate>/<interval>[:<burst>]
#
#			where <rate> is the number of connections per
#			<interval> ("sec" or "min") and <burst> is the
#			largest burst permitted. If no <burst> is given,
#			a value of 5 is assumed. There may be no
#			no whitespace embedded in the specification.
#
#				Example: 10/sec:20
#
#	USER/GROUP	This column may only be non-empty if the SOURCE is
#			the firewall itself.
#
#			The column may contain:
#
#	[!][<user name or number>][:<group name or number>][+<program name>]
#
#			When this column is non-empty, the rule applies only
#			if the program generating the output is running under
#			the effective <user> and/or <group> specified (or is
#			NOT running under that id if "!" is given).
#
#			Examples:
#
#				joe	#program must be run by joe
#				:kids	#program must be run by a member of
#					#the 'kids' group
#				!:kids	#program must not be run by a member
#					#of the 'kids' group
#				+upnpd	#program named upnpd (This feature was
#					#removed from Netfilter in kernel
#					#version 2.6.14).
#
###############################################################################
#TARGET	SOURCE	DEST	PROTO	DEST	SOURCE	ORIGINAL	RATE	USER/
#				PORT	PORT(S)	DEST		LIMIT	GROUP
ACCEPT	eth1	eth2	tcp 99,100
#LAST LINE -- ADD YOUR ENTRIES BEFORE THIS ONE -- DO NOT REMOVE
