#!/usr/bin/env python

"""Convert a PDP11 a.out file to papertape loader format
(a.k.a. "formatted binary").
"""

DEBUG = 0

import sys
import struct

DEFBASE = 01000   # program first word address
TSTART = 020      # start of text in input file

def csum (data):
    cs = 0
    for c in data:
        cs += ord (c)
    return chr ((256 - cs) & 0xff)

inf = open (sys.argv[1], "rb")

data = inf.read ()
inf.close ()
m, tlen, dlen, bsslen, stlen, xfer = struct.unpack ("<HHHHHH", data[:12])

if DEBUG:
    print "text length %06o data length %06o bss %06o transfer %0o0" % \
      (tlen, dlen, bsslen, xfer)
    
# See if we can figure out the program base.  Assume that if
# the first instuction is "mov #foo, sp" then foo is the
# program base.
op, base, x = struct.unpack ("<HHH", data[TSTART:TSTART + 6])
if op == 012737 and base == 0340 and x == 0177776:
    # Start is mov #340, @#ps
    op, base = struct.unpack ("<HH", data[TSTART + 6:TSTART + 10])
if not (op == 012706 and (base & 1) == 0):
    # No obvious base, assume the default
    base = DEFBASE
    print "defaulting base to %06o" % base
elif DEBUG:
    print "base is %06o" % base

if m != 0407 and m != 0410:
    print "Unexpected magic number: %04o" % m
    sys.exit (1)

if TSTART + tlen + dlen > len (data):
    print "text or data section beyond end of input"
    sys.exit (1)

if TSTART + tlen + dlen > 0160000:
    print "Program is too large: %o" % (TSTART + tlen + dlen)
    sys.exit (1)
    
if xfer < base or xfer > base + tlen:
    print "transfer address %06o is out of range" % xfer
    sys.exit (1)

# Data starts on an even address.  Note: this is a function of the
# link script used.  Without a script, the linker apparently pads to a
# multiple of 0400, but pdp11-simh.ld just does alignment to even.
dbase = base + tlen
dbase = (dbase + 1) & -2
    
if DEBUG:
    print "text base %06o data base %06o" % (base, dbase)

outf = open (sys.argv[2], "wb")
    
text = data[TSTART:tlen + TSTART]
data = data[TSTART + tlen:TSTART + tlen + dlen]

l = len (text) + 6
text = struct.pack ("<HHH", 1, l, base) + text
text += csum (text)
outf.write (text)
if DEBUG:
    print "text: %d bytes" % l

if data:
    l = len (data) + 6
    data = struct.pack ("<HHH", 1, l, dbase) + data
    data += csum (data)
    outf.write (data)
    if DEBUG:
        print "data: %d bytes" % l

hdr = struct.pack ("<HHH", 1, 6, xfer)
hdr += csum (hdr)
outf.write (hdr)
if DEBUG:
    print "transfer: 6 bytes"

outf.close ()

