#include "sip.h"

SipInfo info;

void transmit(char *fmt, ... )
{
	va_list ap;

	va_start(ap,fmt);
#ifdef DEBUG
	printf("-> ");
	vprintf(fmt,ap);
	printf("\n");
#endif
	vfprintf(info.out,fmt,ap);
	fprintf(info.out,"%c\n",13);
	va_end(ap);
}

void setcontent(char *fmt, ... )
{
	va_list ap;
	char temp[200];
	va_start(ap,fmt);
#ifdef DEBUG
	printf("((");
	vprintf(fmt,ap);
	printf("))\n");
#endif
	vsprintf(temp,fmt,ap);
	info.content+=temp;
	info.content+=13;
	info.content+=10;
	va_end(ap);
}


void statemachine(void)
{
	int fd,flags;
	if(info.lock) return;
	printf("state=%d\n",info.state);
	switch(info.state)
	{
		case STATE_INIT:
			printf("open UDP connection!\n");
			info.out=fsockopen(info.proxyurl.str(),info.sipport,GS_PROTOCOL_UDP);
		        fd=fileno(info.out);
			flags=fcntl(fd,F_GETFL);
			flags |= O_NONBLOCK;
			fcntl(fd,F_SETFL,flags);

			if(info.out != NULL)
			{
				newstate(STATE_REGISTER);
			}
			break;
		case STATE_REGISTER:
			printf("Register!\n");
			transmit("REGISTER sip:%s:%d SIP/2.0",info.proxyurl.str(),info.sipport);
			transmit("Via: SIP/2.0/UDP %s:%d;branch=z9hG4bK_000FC901556B_T53CBF5E1",info.hostip.str(),info.sipport);
			transmit("Max-Forwards: 70");
			transmit("From: <sip:%s@%s:%d>;tag=000FC901556B_T2082379462",info.user.str(),info.proxyurl.str(),info.sipport);
			transmit("To: <sip:%s@%s:%d>",info.user.str(),info.proxyurl.str(),info.sipport);
			transmit("Call-ID: REGISTER_000FC901556B_T1892262986@%s",info.hostip.str());
			transmit("CSeq: %d REGISTER",time(NULL));
			transmit("Contact: <sip:%s@%s:%d>",info.user.str(),info.hostip.str(),info.sipport);
			transmit("Expires: 3600");
			transmit("User-Agent: %s",AGENT);
			transmit("Content-Length: 0");
			transmit("");
			break;
		case STATE_REGISTER_AUTH:
			if(info.nonce.len() > 0 && info.user.len() > 0 && info.pass.len() > 0 && info.realm.str() > 0)
			{
				printf("Register AUTH!\n");
				char temp[128];

				sprintf(temp,"sip:%s:%d",info.proxyurl.str(),info.sipport);
				info.uri=temp;
				info.method="REGISTER";
				DigestCalcResponse(temp);
				transmit("REGISTER sip:%s:%d SIP/2.0",info.proxyurl.str(),info.sipport);
				transmit("Via: SIP/2.0/UDP %s:%d;branch=z9hG4bK_000FC901556B_T53CBF5E1",info.hostip.str(),info.sipport);
				transmit("Max-Forwards: 70");
				transmit("From: <sip:%s@%s:%d>;tag=000FC901556B_T2082379462",info.user.str(),info.proxyurl.str(),info.sipport);
				transmit("To: <sip:%s@%s:%d>",info.user.str(),info.proxyurl.str(),info.sipport);
				transmit("Call-ID: REGISTER_000FC901556B_T1892262986@%s",info.hostip.str());
				transmit("CSeq: %d REGISTER",time(NULL));
				transmit("Contact: <sip:%s@%s:%d>",info.user.str(),info.hostip.str(),info.sipport);
				transmit("Expires: 3600");
				transmit("User-Agent: %s",AGENT);
				transmit("Authorization: Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", algorithm=md5, opaque=\"\", uri=\"%s\", response=\"%s\"",info.user.str(),info.realm.str(),info.nonce.str(),info.uri.str(),temp);
	
				transmit("Content-Length: 0");
				transmit("");
			}
			else
			{
				printf("Information for auth login not complete, reverting to nonauth!\n");
				newstate(STATE_REGISTER);
			}
			break;
		case STATE_ONLINE:
			printf("Will call in 2 seconds!\n");
			sleep(2);
			newstate(STATE_INVITE);
			break;
		case STATE_INVITE:

			setcontent("v=0");
			setcontent("o=%s 274413945 274413945 IN IP4 %s",info.mynumber.str(),info.hostip.str());
			setcontent("s=%s",AGENT);
			setcontent("c=IN IP4 %s",info.hostip.str());
			setcontent("t=0 0");
			setcontent("m=audio 41000 RTP/AVP 0");
			setcontent("a=rtpmap:0 PCMU/8000/1");
			setcontent("a=sendrecv");

			transmit("INVITE sip:%s@sip.mujtelefon.com:%d SIP/2.0",info.partner.str(),info.sipport);
			transmit("Via: SIP/2.0/UDP %s:%d;branch=z9hG4bK_000FC901556B_T0983D809",info.hostip.str(),info.sipport);
			transmit("Session-Expires: 1800");
			transmit("From: \"%s\" <sip:%s@%s:%d>;tag=000FC901556B_T187221128",info.mynumber.str(),info.mynumber.str(),info.proxyurl.str(),info.sipport);
			transmit("To: <sip:%s@%s:%d>",info.partner.str(),info.proxyurl.str(),info.sipport);
			transmit("Call-ID: CALL_ID1_000FC901556B_T1355481971@%s",info.hostip.str());
			transmit("CSeq: %d INVITE",time(NULL));
			transmit("Contact: <sip:%s@%s:%d>",info.mynumber.str(),info.hostip.str(),info.sipport);
			transmit("Max-Forwards: 70");
			transmit("Allow: ACK,BYE,CANCEL,INVITE,NOTIFY,REFER,DO,UPDATE,OPTIONS,SUBSCRIBE,PRACK,INFO");
			transmit("Supported: 100rel,timer,replaces");
			transmit("User-Agent: %s",AGENT);
			transmit("Content-Type: application/sdp");
			transmit("Content-Length: %d",info.content.len());
			transmit("");
			fprintf(info.out,"%s",info.content.str());
			info.content="";
			break;
				
		default:
			printf("Unknown state %d!\n",info.state);
			exit(1);
	}
}

void stateresponse(void)
{

}

void handler_alarm(int sig)
{
	alarm(5);
	signal(SIGALRM,handler_alarm);
	statemachine();
}

void newstate(int newstate)
{
	info.state=newstate;
	handler_alarm(0);
}

void grantwait(void)
{
	alarm(5);
	signal(SIGALRM,handler_alarm);
}

GsString parse_response_word(GsString answer,GsString topic,GsString att)
{
	GsList<GsString> line,word;
	topic +=":";
	int i,j;
	line=answer.split("\n\r");
	for(i=0;i<line.len();i++)
	{
		word=line[i].split(" \t,");
		if(word.len() > 0)
		{
			if(word[0] == topic)
			{
				for(j=1;j<word.len();j++)
				{
					GsList<GsString> part=word[j].split("=");
					if(part.len() == 2 && part[0] == att)
					{
						GsString result=part[1];
						if(result.first() == '"' && result.last() == '"')
						{
							result.shift();	
							result.pop();
						}
						return result;
					}
				}
			}
		}
	}
	return "";
	
}


void parse_response(GsString answer)
{
	int status;
	GsList<GsString> line,word;
	GsString header;
	line=answer.split("\n\r");
	if(line.len() < 1) return;
	header=line.shift();
	word=header.split(" \t");
	if(word.len() < 3) return;
	int words=sscanf(word[1],"%d",&status);
	if(words == 1)
	{
		if(status == 100) grantwait(); // TRYING
		else if(status == 401 && info.state == STATE_REGISTER)
		{
			info.realm=parse_response_word(answer,"WWW-Authenticate","realm");
			info.nonce=parse_response_word(answer,"WWW-Authenticate","nonce");
			newstate(STATE_REGISTER_AUTH);
		}
		else if(status == 200 && info.state == STATE_REGISTER_AUTH)
		{
			newstate(STATE_ONLINE);
		}
		else
		{
			printf("Got response %d in state %d\n",status,info.state);
		}
	}
	
}

void handle_response(void)
{
	char *ptr;
	char buf[200];
	while(1)
	{
		if(info.out != NULL)
		{
			ptr=fgets(buf,sizeof(buf),info.out);
			if(ptr != NULL)
			{
				GsString content;
				info.lock=1;
				while(ptr != NULL && strlen(ptr) > 2)
				{
#ifdef DEBUG
					printf("<- %s",ptr);
#endif
					content+=ptr;
					ptr=fgets(buf,sizeof(buf),info.out);
				}
				info.lock=0;
				parse_response(content);

			}
		}
	}
}


int main(void)
{
	info.sipport=5060;
	info.hostip="192.168.10.2";

	info.proxyurl="sipgate.at";
	info.mynumber="07201734385";
	info.user="1734385";
	info.pass="NMWTNPKP";
	info.partner="00420272248260";

	newstate(STATE_INIT);
	handle_response();
	return 0;
}
