#include <stdio.h>
#include <string.h>
#include "hostlist.h"

int out_dot = 1;

char buf[10*1024];

void set_span(int total,  int *span, int tree_width)
{
	int left = total;
	int i = 0;

	for(i = 0; i< tree_width; i++){
		span[i] = 0;
	}

	if (total <= tree_width) {
		return;
	}

	while (left > 0) {
		for(i = 0; i < tree_width; i++) {
			if ((tree_width-i) >= left) {
				if (span[i] == 0) {
					left = 0;
					break;
				} else {
					span[i] += left;
					left = 0;
					break;
				}
			} else if (left <= tree_width) {
                if( span[i] == 0 ){
                    left--;
                }
				span[i] += left;
				left = 0;
				break;
			}
            if( span[i] == 0){
                left--;
            }
			span[i] += tree_width;
			left -= tree_width;
		}
	}
}


void start_msg_tree(char *hl, int tree_width, int assign[])
{
	int span[100];
	int j = 0, count = 0;
	char *name = NULL;
	int thr_count = 0;
	int host_count = 0;
    char *launcher;
    int i;

    for(i=0;i<tree_width;i++){
        assign[i] = 0;
    }

	hl = hostlist_shift(hl, &name);
	count = hostlist_count(hl);
    if( count == 0 )
        return;
	
	set_span(count, span, tree_width);

	hl = skip_spaces(hl);
	while ( hl[0] != '\0' ){
        assign[thr_count]++;
		char hl_child[1024] = "";
		hl = hostlist_shift(hl, &name);
		for (j = 0; j < span[thr_count]; j++) {
			hl = hostlist_shift(hl, &name);
			if ( name[0] == '\0' )
				break;
            assign[thr_count]++;
		}
		thr_count++;
	}
	return;
}

int main(int argc, char**argv)
{
	char hl[1024] = "";
	int count, maxcount = 20;
	int tree_width = 3;
    int i;
    int span[100], assign[100];
	
    if( argc > 1 ){
        maxcount = atoi(argv[1]);
    }

    for(count=1; count < maxcount; count++){
        hl[0] = '\0';
        for(i=0;i<count;i++){
		    sprintf(hl,"%s cn%d",hl,i+1);
	    }

        set_span(count-1,span,tree_width);
        start_msg_tree(hl,tree_width,assign);
        printf("count=%d, span: ",count);
        for(i=0;i<tree_width;i++){
            printf("%d ",span[i]);
        }
        printf("; ");
        printf("assign: ");
        for(i=0;i<tree_width;i++){
            printf("%d ",assign[i]);
        }
        printf("\n");
    }
        
    return 0;
}
