package dk.util.address;

import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.soap.*;
import org.apache.soap.rpc.*;
import org.apache.soap.encoding.*;
import org.apache.soap.util.xml.*;
import dk.util.address.*;

public class LocationsServiceTest {

	public static void main (String[] argv) throws Exception {
		URL url = new URL("http://localhost:8080/soap/servlet/rpcrouter");
    	String soapEncoding = Constants.NS_URI_SOAP_ENC;
    	String jaxbEncoding = "http://java.sun.com/xml/jaxb/";
		String dkNamespace = "dk.util.address";

		Call call = new Call ();
		call.setTargetObjectURI ("urn:LocationsService");
		//call.setMethodName ("addJaxbLocation");
		call.setMethodName ("addJaxbLocation");
		call.setEncodingStyleURI(soapEncoding);
		//call.setTargetObjectURI(dkNamespace);

		Serializer ser = new dk.util.soap.JAXBSerializer();
		Deserializer des = (Deserializer)ser;

		SOAPMappingRegistry mr = new SOAPMappingRegistry();
		mr.mapTypes(soapEncoding, new QName("urn:dk.util.address","location"), Location.class ,ser,des);
		call.setSOAPMappingRegistry(mr);

		Location newLoc = new Location();
		newLoc.setId(new Long(1l));
		newLoc.setName("Frankfurt");

		newLoc.validate();

		//newLoc.marshal(System.out);
		//OutputStream out = new ByteArrayOutputStream(1000);
		//newLoc.marshal(out);

		Vector params = new Vector ();
	    params.addElement (new Parameter("location", Location.class, newLoc , soapEncoding));
    	call.setParams (params);

		Response resp = call.invoke (url,"" );

		if (resp.generatedFault ()) {
		  Fault fault = resp.getFault ();
		  System.out.println ("the call failed: ");
		  System.out.println ("  Fault Code   = " + fault.getFaultCode ());  
		  System.out.println ("  Fault String = " + fault.getFaultString ());
		} else {
		  Parameter result = resp.getReturnValue ();
		  System.out.println (result.getValue ());
		}
  }
}
