package dk.util.soap;

import java.io.*;
import org.apache.soap.util.*;
import org.apache.soap.util.xml.*;
import org.apache.soap.*;
import org.apache.soap.rpc.*;
//import javax.xml.bind.*;
//import javax.xml.bind.PredicatedLists.Predicate;
//import javax.xml.marshal.*;
import javax.xml.parsers.*;
import java.lang.reflect.*;
import org.w3c.dom.*;

public class JAXBSerializer implements Serializer, Deserializer
{

/*     !!!!!!!!!!!!!!!!!!!!!! */
/*     	the package nam eof the clss can be determined from SOAP Context, but i have't done it yet
	so package name ist hardcoded, you must adjust it for your needs or write a code accessing 
	rigth information from SOAP context.
*/	
	public static String jaxbClassesPackageName = "dk.util.address";

	public void marshall(String inScopeEncStyle, Class javaType, Object src,
                       	Object context, Writer sink, NSStack nsStack,
                       	XMLJavaMappingRegistry xjmr, SOAPContext ctx)
    throws IllegalArgumentException, IOException
  	{
    	nsStack.pushScope();

    	if (src instanceof javax.xml.bind.MarshallableRootElement)
    	{
    		javax.xml.bind.MarshallableRootElement mre = (javax.xml.bind.MarshallableRootElement) src;
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			javax.xml.marshal.XMLWriter wr = new javax.xml.marshal.XMLWriter(baos,"UTF-8",false);
			mre.marshal(wr);
			System.out.println("JAXBSerializer, writing: "+baos.toString());
			sink.write(baos.toString());
    	}
	    else
    	{
      		throw new IllegalArgumentException("I only know how to serialize " +
                                         "an 'MarshallableRootElement.class' object.");
    	}
    	nsStack.popScope();
  	}

	public Bean unmarshall(String inScopeEncStyle, QName elementType, org.w3c.dom.Node src,
                         XMLJavaMappingRegistry xjmr, SOAPContext ctx)
    throws IllegalArgumentException
  	{
		org.w3c.dom.Element el = (org.w3c.dom.Element)src;

		String elString = DOM2Writer.nodeToString(el);
		System.out.println("JAXBSerializer, deserializing :"+elString);

		InputStream in = new ByteArrayInputStream(elString.getBytes());

		//getting element  name	- after processing class name
		String elName = el.getTagName();
		System.out.println("JAXBSerializer, unmarshaling element with name: "+elName);

		//modyfiing class name
		String elClassName = jaxbClassesPackageName + "." + elName.substring(0,1).toUpperCase() + elName.substring(1);
		System.out.println("JAXBSerializer, alClassName after modyfication: "+elClassName);
		Class elClass; 
		try {
			elClass = ctx.loadClass(elClassName);
		} catch (ClassNotFoundException cnfex) {
			System.out.println(cnfex);
        	throw new IllegalArgumentException("class " + elClassName + " not found");
		}	
		System.out.println("JAXBSerializer, class "+elClassName+" loaded.");

		//getting unmarshal(Input Stream) method
		Method unmarshaller;
		try	{
			unmarshaller = elClass.getMethod("unmarshal", new Class[] { InputStream.class } );
		} catch (NoSuchMethodException nsmex) {
			System.out.println(nsmex);
			throw new IllegalArgumentException("method newDispather not found in class "+elClassName);
		}	

		//unmasrahling 
		javax.xml.bind.MarshallableRootElement jaxbElement;
		try	{
			jaxbElement = (javax.xml.bind.MarshallableRootElement) unmarshaller.invoke(null,new Object[] { in });
		} catch (IllegalAccessException iaex) {
			System.out.println(iaex);
			throw new IllegalArgumentException("method newDispather not accessible");
		} catch (InvocationTargetException itex) {
			System.out.println(itex);
			throw new IllegalArgumentException("method newDispather un class "+elClassName+" coused exception");
		}		

		//validating
		try {
			jaxbElement.validate();
		} catch (javax.xml.bind.StructureValidationException svex) {
			throw new IllegalArgumentException("error while validating JAXB object");
		}	

		//returning value
		System.out.println("unmarshalled");
/*
		Parameter parameter = new Parameter(elementName,
											elementClass,
											jaxbElement,
											null);
*/
		return new Bean(elClass, jaxbElement);
	}
	
}
