<?php


   if (file_exists('../../include/init.php'))
      include_once('../../include/init.php');
   else if (file_exists('../../include/validate.php'))
   {
      define('SM_PATH', '../../');
      include_once(SM_PATH . 'include/validate.php');
   }
   else
   {
      chdir('..');
      define('SM_PATH', '../');
      include_once(SM_PATH . 'src/validate.php');
   }


   include_once (SM_PATH . 'functions/imap.php');
   include_once (SM_PATH . 'plugins/mark_read/functions.php');
   mark_read_init();


global $imapServerAddress, $imapPort, $username, $key;

function mark_read_mark_mailbox($imap_stream, $mailbox, $read) {

    // figure out if there are any messages to delete
    //
    if (check_sm_version(1, 3)) 
    {
       $mbx_response = sqimap_mailbox_select($imap_stream, $mailbox);
       $mbx_response = $mbx_response['EXISTS'];
    } 
    else 
    {
       $mbx_response = sqimap_get_num_messages($imap_stream, $mailbox);
    }


    // if so, move to trash or expunge, depending on desired behavior
    //
    if ($mbx_response > 0) {

       sqimap_mailbox_select($imap_stream, $mailbox);


       // mark_read out the mailbox
       //
       if( $read ) {
          sqimap_messages_remove_flag ($imap_stream, 1, '*', 'Seen', false);
       } else { 
          sqimap_messages_flag ($imap_stream, 1, '*', 'Seen', false);
       }

    }
}

global $username, $base_uri;
sqGetGlobalVar('key', $key, SQ_COOKIE);
// FIXME: TODO: this does not appear to be used anywhere herein
//sqGetGlobalVar('delimiter', $delimiter, SQ_SESSION);
// FIXME: TODO: this does not appear to be used anywhere herein
//sqGetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);

// FIXME: TODO: where is $mailbox coming from?  the following line may not be correct!
sqGetGlobalVar('mailbox', $mailbox);
if (isset($mailbox)){
    $mailbox = urldecode( $mailbox );
}
sqGetGlobalVar('markallread', $markallread);
sqGetGlobalVar('mark', $mark);

// should we expunge or move to trash?
//
//$mark_read_link_behavior = getPref($data_dir, $username,
//                                       'mark_read_link_behavior',
//                                       $default_mark_read_link_behavior);


// no longer needed
// do_hook('session_recall');

$imap_stream = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);

// mark all read or just one mailbox?
if ( $markallread == '1' ) {
   // grab preferences
   $allFolders = getPref($data_dir, $username, 'mark_read_show_link', '');

   // load default folders if none have previously been chosen
   if ($allFolders == 'NONE') $allFolders = '';
   else if ($allFolders == '')
   {
      $allFolders = implode('###', $default_folders_to_show_mark_read_link);
   }
   $mark_read_folders = explode('###', $allFolders);
   
   foreach($mark_read_folders as $mailbox) {
       if ( !($mailbox == '') ) {
           mark_read_mark_mailbox($imap_stream, $mailbox, ($mark=="unread"));
       }
   }

} else if (isset($mailbox)) {
    mark_read_mark_mailbox($imap_stream, $mailbox, ($mark=="unread"));
}

header ('Location: ' . $base_uri . '../../src/left_main.php');

sqimap_logout($imap_stream);

?>
