clear all
close all
clc

import traci.constants
% Get the filename of the example scenario
[scenarioPath,~,~] = fileparts(which(mfilename));
cd(scenarioPath);

system(['sumo-gui -c ' './ring.sumocfg &']);

%mclInitializeApplication();

maxplatoonSize = 8;
spdNormalVeh = 20;
spdPlatoon = 26;
normalAccel = 6;
normalDecel = 6;
near = 30;
duration = 200;
deltaSpeed{1} = 0.5;
deltaSpeed{2} = 2;
intraPlatoonGap = 10.0000;
initialPlatoonSpd = 2;
spd = zeros(duration, maxplatoonSize);
gap = zeros(duration, maxplatoonSize);
platoon = {};
% platoon{1} = 'vA.0';
isStable = true;
isManeuverState = false;
isUniformSpeed = true;
nearVeh = '';
startingGap = -1;
strategy = 'FrontMerge_AdjustPlatoon';
% strategy = 'FrontMerge_AdjustVeh'; 
% strategy = 'EndMerge_AdjustPlatoon'; 
% strategy = 'EndMerge_AdjustVeh'; 


traci.init();
for i = 1: duration
    if(i==98)
        v = 'wait';
    end    
    traci.simulationStep(); 
    veh = cellstr(traci.vehicle.getIDList); 
    
    if(i == 1)
        for vehInxd = 1 : maxplatoonSize - 1   
            vID = strcat('v',int2str(size(platoon, 2)+1));
            traci.vehicle.add(vID, 'round5A', vehInxd, 0, 2, 1, 'Follow_IDM');
            platoon{end+1} = vID;
            traci.vehicle.setLaneChangeMode(vID, 0);
%             if(vehInxd > 1)
                traci.vehicle.setSpeedMode(vID, 0);
%             else
%                 traci.vehicle.setSpeedMode(vID, 1);
%             end            
        end        
    end
    if(size(veh, 2) <  maxplatoonSize - 1)
        SetDesiredPlatoonSpeed(platoon, initialPlatoonSpd, normalAccel);  
        continue;        
    end
    if(i == 32)
        SetDesiredPlatoonSpeed(platoon, spdPlatoon, normalAccel);
        isDesiredSpeed = true;
    elseif(i == 40)
        posFirstMem = traci.vehicle.getLanePosition(char(platoon(1)));  
       % posLastMem = traci.vehicle.getLanePosition(char(platoon(end)));          
        vID = strcat('v',int2str(size(platoon, 2)+1));
        traci.vehicle.add(vID, 'round5B', i, posFirstMem + spdPlatoon + 40, spdNormalVeh, 0, 'Follow_IDM');
        traci.vehicle.setLaneChangeMode(vID, 0);
        traci.vehicle.setSpeedMode(char(platoon(1)), 1);
    end 
    
    if(startingGap < 0 && any(ismember(veh, 'v8')))        
        posFirstMem = traci.vehicle.getLanePosition(char(platoon(1)));          
       % posLastMem = traci.vehicle.getLanePosition(char(platoon(end)));   
        posMergingVeh = traci.vehicle.getLanePosition('v8');        
        startingGap = posMergingVeh - posFirstMem;
    end
%      
    
    % check current speed and gap
    [gap spd] = vehicleStat(veh, platoon, i, gap, spd, intraPlatoonGap);
    % gap(i, 1:8)
    % 	spd(i, 1:8)
     % stable all vehicles other than platoon 
    stayStable(veh, spdNormalVeh, platoon);
    
    if(~isManeuverState)
        isProperGap = CheckIntraPlatoonGap(platoon, intraPlatoonGap);
        if(~isProperGap)            
            isProperGap = SetProperGap(platoon, intraPlatoonGap, normalAccel, normalDecel); 
        else
%             isDesiredSpeed = CheckDesiredSpeed(platoon, spdPlatoon);
             if(~isDesiredSpeed)
                 % setting desired speed and accel of followers 
                 SetDesiredPlatoonSpeed(platoon, spdPlatoon, normalAccel); 
                 isDesiredSpeed = true;
             else
                 %set next step speed
                SetNextLevelSpeed(platoon, normalAccel, normalDecel, intraPlatoonGap);
                % setting follower speed as leader speed 
%                 isUniformSpeed = FollowLeaderSpeed(platoon, normalAccel, normalDecel);
            end
            if(isempty(nearVeh))
                nearVeh = findNearest(platoon, near);
                if(~isempty(nearVeh))
                    isManeuverState = true; 
                end
            end
        end
    end  
    if(isManeuverState)
        if(~isempty(nearVeh))
            platoonSizeBefore = size(platoon, 2);        
            platoon = mergeWithinRange(platoon, nearVeh, deltaSpeed, intraPlatoonGap, normalAccel, normalDecel, spdPlatoon, strategy); 
            if(size(platoon, 2) > platoonSizeBefore)
                nearVeh = ''; 
                isManeuverState = false;
                isDesiredSpeed = false;
            else
                isManeuverState = true; 
            end  
        end
    end
%    if(size(platoon, 2) == maxplatoonSize)
%        DrawGraphs(spd, gap, duration, spdPlatoon);
%        duration = i;
%    end
   
end
traci.close();

% if any vehicle is not in a platoon maintain speed
function stayStable(veh, spd, platoon)
    for vehInxd = 1 : size(veh, 2)  
        if(~any(ismember(platoon, char(veh(vehInxd)))))        
            traci.vehicle.setSpeed(char(veh(vehInxd)), spd);
        end           
    end
end

function platoon = mergeWithinRange(platoon, mergingVeh, deltaSpeed, intraPlatoonGap, normalAccel, normalDecel, spdPlatoon, strategy)
    % Donot do any maneuver at 
    edgPlatoonLead = traci.vehicle.getRoadID(char(platoon(1)));
    edgPlatoonTail = traci.vehicle.getRoadID(char(platoon(size(platoon, 2))));
    edgMergingVeh = traci.vehicle.getRoadID(mergingVeh);
    if(contains(strategy,'FrontMerge') && ~strcmp(edgPlatoonLead,edgMergingVeh))
        return;
    elseif(contains(strategy,'EndMerge') && ~strcmp(edgMergingVeh,edgPlatoonTail))
        return;
    end
    
    spdLeader = traci.vehicle.getSpeed(char(platoon(1)));
    spdMergingVeh = traci.vehicle.getSpeed(mergingVeh);
    posLead = traci.vehicle.getLanePosition(char(platoon(1))); 
    posMergingVeh = traci.vehicle.getLanePosition(mergingVeh); 
    currentGap = posMergingVeh - posLead;
    coveringDist = currentGap - intraPlatoonGap;
    % platoon covering dist and slowing down to allow vehicle to merge    
    if(abs(coveringDist) < 0.000001)
         for vehInxd = 1 : size(platoon, 2)         
            memVeh = char(platoon(vehInxd));
            traci.vehicle.setSpeedMode(memVeh, 0);
            traci.vehicle.setSpeed(memVeh, spdMergingVeh);            
         end
         traci.vehicle.changeLane(mergingVeh, 1, 50);  
         traci.vehicle.setLaneChangeMode(mergingVeh, 0);   
         traci.vehicle.setSpeedMode(mergingVeh, 0);
         platoon = updatePlatoon(platoon, mergingVeh);
    else
        if(coveringDist<0)
            v = '';
        end
        for vehInxd = 1 : size(platoon, 2)        
            memVeh = char(platoon(vehInxd));
            spdMem = traci.vehicle.getSpeed(memVeh);
            reqChange = spdMergingVeh + coveringDist - spdMem;
            
            if(reqChange > 0)
                if(spdMem < spdPlatoon)
                    if(reqChange < normalAccel) 
                        traci.vehicle.setSpeed(memVeh, spdMem + reqChange);
                    else
                        traci.vehicle.setSpeed(memVeh, spdMem + normalAccel);
                    end
                end
            else                
                if(abs(reqChange) < normalDecel) 
                    traci.vehicle.setSpeed(memVeh, spdMem + reqChange);
                else
                    traci.vehicle.setSpeed(memVeh, spdMem - normalDecel);
                end
            end
        end        
    end      
end

function nearVeh = findNearest(platoon, near)     
    pos_platoon_lead = traci.vehicle.getLanePosition(char(platoon(1))); 
    edg_platoon = traci.vehicle.getRoadID(char(platoon(1)));
    veh_edg = traci.edge.getLastStepVehicleIDs(edg_platoon);
    nearVeh = '';
    for vehInxd = 1 : size(veh_edg, 2)  
        if(~any(ismember(platoon, char(veh_edg(vehInxd)))))  
            pos_veh = traci.vehicle.getLanePosition(char(veh_edg(vehInxd)));
            %pos_veh - pos_platoon_lead > 0  &&
            if( abs(pos_veh - pos_platoon_lead) < near)
                nearVeh = char(veh_edg(vehInxd));
            end
        end
    end    
end

function platoon = updatePlatoon(platoon, mergingVeh)
    %currentSize = size(platoon, 2);
    for shftCount = size(platoon, 2) : -1 : 1
        platoon{shftCount+1} = platoon{shftCount};
    end
    platoon{1} = mergingVeh;
end

function [gap, spd]  = maintainPlatoon(platoon, iter, gap, spd, spdPlatoon, intraPlatoonGap)    
    leadVeh = char(platoon(1));
    traci.vehicle.setSpeed(leadVeh, spdPlatoon);
%     %traci.vehicle.setAccel(leadVeh, 0);
%     %traci.vehicle.setDecel(leadVeh, 0);   
    spdLeader = traci.vehicle.getSpeed(leadVeh);
    spd(iter, 1) = spdLeader;
    accLeadVeh = traci.vehicle.getAccel(char(platoon(1)));
    decelLeadVeh = traci.vehicle.getAccel(char(platoon(1)));
    edgPrev = traci.vehicle.getRoadID(char(platoon(1)));
    posPrevious = traci.vehicle.getLanePosition(char(platoon(1)));
    for vehInxd = 2 : size(platoon, 2)        
        follVeh = char(platoon(vehInxd));
        edgNext = traci.vehicle.getRoadID(follVeh);
        posNext = traci.vehicle.getLanePosition(follVeh);
        if(strcmp(edgPrev,edgNext))
            gap(iter, vehInxd) = posPrevious - posNext;
        else 
            if(contains(edgNext,':'))
                distFromJunc = 0;
            else
                from = edgNext(1:1);
                to = edgNext(2:2);
                distBetnJunc = abs(traci.junction.getPosition(from) - traci.junction.getPosition(to));
                distFromJunc = (distBetnJunc(1) + distBetnJunc(2)) - posNext;
            end
            gap(iter, vehInxd) = posPrevious + distFromJunc;
%             gap(iter, vehInxd) = gap(iter-1, vehInxd);
        end
        spdfoll = traci.vehicle.getSpeed(follVeh);
        spd(iter, vehInxd) = spdfoll;
        chaccel = traci.vehicle.getAccel(follVeh);
        decelVeh = traci.vehicle.getAccel(follVeh);
        discrip = gap(iter, vehInxd) - intraPlatoonGap;
        if(abs(discrip) < 0.00001)
            traci.vehicle.setSpeed(follVeh, spdLeader);
        elseif(discrip > 0 )
            traci.vehicle.setSpeed(follVeh, spdLeader + discrip);
        else 
            traci.vehicle.setSpeed(follVeh, spdLeader - discrip);
        end           
        
    end
end

function isProperGap = CheckIntraPlatoonGap(platoon, intraPlatoonGap)  
    isProperGap = false;
    isProperdist = {};
    isProperdist{1} = 'true';
    intraPlatoonDist = GetIntraPlatoonDist(platoon, intraPlatoonGap);
    % setting gap
    for vehInxd = 2 : size(platoon, 2)        
        discrepancy = intraPlatoonDist(vehInxd) - intraPlatoonGap;
        if( abs(discrepancy) < 0.000001)                
            isProperdist{vehInxd} = 'true';       
        else            
            isProperdist{vehInxd} = 'false';
        end
    end  
    if(~any(ismember(isProperdist, 'false')))        
        isProperGap = true;        
    end    
end

function isProperGap = SetProperGap(platoon, intraPlatoonGap, normalAccel, normalDecel)  
    isProperGap = false;
    isProperdist = {};
    isProperdist{1} = 'true';
    prevVeh = char(platoon(1));
    spdPrev = traci.vehicle.getSpeed(prevVeh);
      
    intraPlatoonDist = GetIntraPlatoonDist(platoon, intraPlatoonGap);
    % setting gap
    for vehInxd = 2 : size(platoon, 2)
        follVeh = char(platoon(vehInxd));
        discrepancy = intraPlatoonDist(vehInxd) - intraPlatoonGap;
        % achieveed the req gap 
        if( abs(discrepancy) < 0.000001)
            %traci.vehicle.setSpeed(follVeh, spdPrev);   
            %traci.vehicle.setAccel(follVeh, 0);
            %traci.vehicle.setDecel(follVeh, 0);
            isProperdist{vehInxd} = 'true'; 
        else
            spdFoll = traci.vehicle.getSpeed(follVeh);
            % current follower speed is less than target speed, need to
            % accel
            if(spdFoll < (spdPrev + discrepancy))
                %traci.vehicle.setAccel(follVeh, normalAccel);
                %traci.vehicle.setDecel(follVeh, 0);
            % current follower speed is more than target speed, need to
            % decel
            else
                %traci.vehicle.setDecel(follVeh, normalDecel);
                %traci.vehicle.setAccel(follVeh, 0);
            end
            traci.vehicle.setSpeed(follVeh, spdPrev + discrepancy);
            isProperdist{vehInxd} = 'false';
        end
    end  
    if(~any(ismember(isProperdist, 'false')))
        isProperGap = true;
    end    
end

function SetDesiredPlatoonSpeed(platoon, spdPlatoon, normalAccel) 
    for vehInxd = 1 : size(platoon, 2)     
        if(vehInxd ~= 1)
            %traci.vehicle.setAccel(char(platoon(vehInxd)), normalAccel);
            %traci.vehicle.setDecel(char(platoon(vehInxd)), 0);
        end
        traci.vehicle.setSpeed(char(platoon(vehInxd)), spdPlatoon);                  
    end
end
    
function isUniformSpeed = FollowLeaderSpeed(platoon, normalAccel, normalDecel)    
    isUniformSpeed = false;
    spdVeh = {};
    spdVeh{1} = 'true';
    leadVeh = char(platoon(1));
    spdLead = traci.vehicle.getSpeed(leadVeh);   
      
    for vehInxd = 2 : size(platoon, 2)
        follVeh = char(platoon(vehInxd));
        spdfoll = traci.vehicle.getSpeed(follVeh);
        spdDiff = spdLead - spdfoll;        
        traci.vehicle.setSpeed(follVeh, spdLead);
        if( abs(spdDiff) < 0.000001)
            spdVeh{vehInxd} = 'true';
        elseif(spdDiff > 0)
            spdVeh{vehInxd} = 'false';
        else 
            spdVeh{vehInxd} = 'false';
        end
    end 
    if(~any(ismember(spdVeh, 'false')))
        isUniformSpeed = true;
    end    
    
end

function nearVeh = SetNextLevelSpeed(platoon, normalAccel, normalDecel, intraPlatoonGap)  
    pos_platoon_lead = traci.vehicle.getLanePosition(char(platoon(1))); 
    edg_platoon = traci.vehicle.getRoadID(char(platoon(1)));
    lane_platoon = traci.vehicle.getLaneID(char(platoon(1)));
    veh_edg = traci.edge.getLastStepVehicleIDs(edg_platoon);
    nearVeh = '';
    dist = 9999;
    for vehInxd = 1 : size(veh_edg, 2)  
        if(~any(ismember(platoon, char(veh_edg(vehInxd)))))              
            pos_veh = traci.vehicle.getLanePosition(char(veh_edg(vehInxd)));
            lane_veh = traci.vehicle.getLaneID(char(veh_edg(vehInxd)));
            %pos_veh - pos_platoon_lead > 0  &&
            if(contains(lane_platoon, lane_veh) && ((pos_veh - pos_platoon_lead) > 0.00001) && ((pos_veh - pos_platoon_lead) < dist))                
                nearVeh = char(veh_edg(vehInxd));
                dist = pos_veh - pos_platoon_lead;
                
            end
        end
    end 
    
    if(isempty(nearVeh))
%         edgeLength = traci.lane.getLength(edg_platoon);
        distFromJunc = 0; 
        if(~contains(edg_platoon,':'))
            from = edg_platoon(1:1);
            to = edg_platoon(2:2);
            distBetnJunc = abs(traci.junction.getPosition(from) - traci.junction.getPosition(to));
            distFromJunc = (distBetnJunc(1) + distBetnJunc(2)) - pos_platoon_lead;
        end
        if(distFromJunc < 2*intraPlatoonGap) 
            route = traci.vehicle.getRoute(char(platoon(1)));
            indx = strmatch(edg_platoon, route, 'exact');
            if(~isempty(indx))
                nextEdg = char(route(indx(1) + 1));
                veh_nextEdg = traci.edge.getLastStepVehicleIDs(nextEdg);
                for vehInxd = 1 : size(veh_nextEdg, 2)  
                    if(~any(ismember(platoon, char(veh_nextEdg(vehInxd)))))              
                        pos_veh = traci.vehicle.getLanePosition(char(veh_nextEdg(vehInxd)));
                        lane_veh = traci.vehicle.getLaneID(char(veh_nextEdg(vehInxd)));
                        if(contains(lane_platoon(4:4), lane_veh(4:4)) && (pos_veh < dist))                
                            nearVeh = char(veh_nextEdg(vehInxd));
                            dist = distFromJunc + pos_veh;
                        end
                    end
                 end 
            end
        end
    end
    if(~isempty(nearVeh))
        s0 = traci.vehicle.getMinGap(char(platoon(1)));
        tau = traci.vehicle.getTau(char(platoon(1)));
        v_alpha = traci.vehicle.getSpeed(char(platoon(1)));
        v_alpha_pre = traci.vehicle.getSpeed(nearVeh);      
		v0 = traci.vehicle.getMaxSpeed(char(platoon(1)));
        sstar =  s0 + v_alpha*tau + ((v_alpha*(v_alpha-v_alpha_pre))/ (2*sqrt( normalAccel * normalDecel)));
		s_alpha = dist - traci.vehicle.getLength(nearVeh);
		accel = normalAccel*(1 - (v_alpha/v0)^4 - (sstar/s_alpha)^2);
        for vehInxd = 1 : size(platoon, 2)
            follVeh = char(platoon(vehInxd));        
            traci.vehicle.setSpeed(follVeh, v_alpha+accel );
        end
    end    
    
end

function isDesiredSpeed = CheckDesiredSpeed(platoon, spdPlatoon)    
    isDesiredSpeed = false;
    spdVeh = {};  
    for vehInxd = 1 : size(platoon, 2)
        memVeh = char(platoon(vehInxd));
        spdmem = traci.vehicle.getSpeed(memVeh);
        spdDiff = spdPlatoon - spdmem;     
        if( abs(spdDiff) < 0.000001)
            spdVeh{vehInxd} = 'true';           
        else
            spdVeh{vehInxd} = 'false';
        end
    end 
    if(~any(ismember(spdVeh, 'false')))
        isDesiredSpeed = true;
    end    
end

function intraPlatoonDist = GetIntraPlatoonDist(platoon, intraPlatoonGap)
    intraPlatoonDist = [];
    intraPlatoonDist(1) = intraPlatoonGap;
    edgPrev = traci.vehicle.getRoadID(char(platoon(1)));
    posPrevious = traci.vehicle.getLanePosition(char(platoon(1)));
    
    for vehInxd = 2 : size(platoon, 2)        
        follVeh = char(platoon(vehInxd));
        edgNext = traci.vehicle.getRoadID(follVeh);
        posNext = traci.vehicle.getLanePosition(follVeh);
        if(strcmp(edgPrev,edgNext))
            intraPlatoonDist(vehInxd) = posPrevious - posNext;
        else 
%             if(strfind(edgNext,':'))
%                 distFromJunc = 0 - posNext;           
%             else
%                 from = edgNext(1:1);
%                 to = edgNext(2:2);
%                 distBetnJunc = abs(traci.junction.getPosition(from) - traci.junction.getPosition(to));
%                 distFromJunc = (distBetnJunc(1) + distBetnJunc(2)) - posNext;
%             end
%             intraPlatoonDist(vehInxd) = posPrevious + distFromJunc;
            intraPlatoonDist(vehInxd) = intraPlatoonGap;
        end
        edgPrev = edgNext;
        posPrevious = posNext;
    end
end

function [gap spd] = vehicleStat(veh, platoon, i, gap, spd, intraPlatoonGap)
    intraPlatoonDist = GetIntraPlatoonDist(platoon, intraPlatoonGap);
    for vehInxd = 1 : size(platoon, 2)
        gap(i, vehInxd) = intraPlatoonDist(vehInxd);
        spd(i, vehInxd) = traci.vehicle.getSpeed(char(platoon(vehInxd)));
    end    
end

function DrawGraphs(spd, gap, duration, spdPlatoon)
    steps = 1:duration;
    %plot(steps,spd0,'r',steps,spd1,'g--',steps,spd2,'b--o',steps,spd3,'m--','LineWidth',1.2);
    plot(spd, 'LineWidth',1.2);
    ylim([0 (spdPlatoon+2)]);
    
    title(['Platoon slows down and vehicle joins at front', num2str(i)]);
    %legend('y = spd0','y = spd1','y = spd2','y = spd3');
    xlabel('Simulation Step'); % x-axis label
    ylabel('Speed Variation'); % y-axis label

end