package org.md.catalina.logger;

/** An exception that gets thrown during communication with a SMTP server. 
 * @author cgokey@gcmd.nasa.gov
 **/

public class SMTPException extends Exception {
	private Exception cause;

	/**
	 * Constructs an exception without cause or reason.
	 */
	public SMTPException() {
		this("An exception for no reason whatsoever.", null);
	}

	/**
	 * Constructs a new exception for the specified reason.
	 * @param reason the reason the operation failed
	 */
	public SMTPException(String reason) {
		this(reason, null);
	}

	/**
	 * Constructs a new exception caused by the specified exception.
	 * @param e the exception causing the operation to fail
	 */
	public SMTPException(Exception e) {
		this("A persisitence exception caused by: " + e.getMessage(), e);
	}

	/**
	 * Constructs a new exception with both a cause and reason.
	 * @param reason the reason for the exception
	 * @param e the cause
	 */
	public SMTPException(String reason, Exception e) {
		super(reason);
		cause = e;
	}

	/** Gets the exception that caused the operation to fail.
	   * @return the exception that caused the operation to fail
	   */
	public Exception getException() {
		return cause;
	}
}
