package org.md.catalina.logger;

import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.logging.ErrorManager;

import javax.servlet.ServletException;

import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;

/**
 * Captures logging events and mails them to a specified email address.
 * @author cgokey@gcmd.nasa.gov
 *
 */
public class TomcatLogger implements Logger {
	Container container;
	int verbosity = ERROR;
	Vector listeners = new Vector();
	String smtp;
	String email;

	// Add a property change listener to this component.
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		listeners.add(listener);
	}

	// Sets the server used to deliver the email.
	public void setSmtp(String s) {
		System.out.println("setting smtp=" + s);
		this.smtp = s;
	}

	// Gets the server used in delivering the email.
	public String getSmtp() {
		return smtp;
	}

	// Sets the email address of the interested person.
	public void setEmail(String s) {
		System.out.println("setting email=" + s);
		this.email = s;
	}

	// Gets the email address of the interested person.
	public String getEmail() {
		return email;
	}

	// Return the Container with which this Logger has been associated.
	// TODO: Not implemented
	public Container getContainer() {
		return container;
	}

	// Return descriptive information about this Logger implementation and the corresponding version number
	public String getInfo() {
		return "org.md.catalina.logger.TomcatLogger/4.03";
	}

	// Return the verbosity level of this logger.  Messages logged with a higher verbosity than this level will be silently ignored.
	public int getVerbosity() {
		return verbosity;
	}

	// Emails the specified exception and message.
	public void log(Exception exception, String msg) {
		log(msg,exception);
	}

	// Ignores messages that do not have verbosiy specified.
	public void log(String msg) {
	}

	// Emails the specified message if the logger is set to a verbosity level equal 
	// to or higher than the specified value for this message.
	public void log(String msg, int verbosity) {
		if (this.verbosity >= verbosity) {
			SMTPClient client = new SMTPClient(smtp);
			try {
				client.send(email, email, null, "Tomcat Error", msg);
			} catch (Exception e) {
				e.printStackTrace();
				return;
			}
		}
	}

	// Emails the specfied message and exception.
	public void log(String msg, Throwable throwable) {
		CharArrayWriter buf = new CharArrayWriter();
		PrintWriter writer = new PrintWriter(buf);
		writer.println(msg);
		throwable.printStackTrace(writer);
		Throwable rootCause = null;
		if (throwable instanceof LifecycleException)
			rootCause = ((LifecycleException) throwable).getThrowable();
		else if (throwable instanceof ServletException)
			rootCause = ((ServletException) throwable).getRootCause();
		if (rootCause != null) {
			writer.println("----- Root Cause -----");
			rootCause.printStackTrace(writer);
		}
		SMTPClient client = new SMTPClient(smtp);
		try {
			client.send(email, email, null, "Tomcat Error", buf.toString());
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
	}

	// Emails the specified message and exception if the logger is set to a verbosity level equal 
	// to or higher than the specified value for this message.
	public void log(String message, Throwable throwable, int verbosity) {
		if (this.verbosity >= verbosity)
			log(message, throwable);

	}

	// Remove a property change listener from this component.
	// TODO: Not implemented
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		listeners.remove(listener);

	}

	// Set the Container with which this Logger has been associated.
	// TODO: Not implemented
	public void setContainer(Container container) {
		this.container = container;
	}

	// Set the verbosity level of this logger. Messages logged with a higher verbosity than this level will be silently ignored.
	public void setVerbosity(int verbosity) {
		this.verbosity = verbosity;
	}

}
