#!/bin/bash
cd /data/development/trac/clientstep/
MINTICKET=0
echo $(date) "Updating tickets from ticket $MINTICKET" >> /tmp/update-trac-tickets.log
tar cfz /tmp/tracdb-$(date +%s).tgz db  >> /tmp/update-trac-tickets.log 2>&1
if [ "$?" != "0" ]; then
   echo "tar failed" >> /tmp/update-trac-tickets.log 
   exit 1;
fi
svn log --xml svn://svn | sed 's/<msg\(.*\)#\([0-9]*\)/<msg ticket="\2"\1#\2/' > /tmp/svn.xml
if [ "$?" != "0" ]; then
   echo "svn log failed" >> /tmp/update-trac-tickets.log 
   exit 1;
fi
xsltproc --param minticket $MINTICKET -o /tmp/trac.sql /home/www-data/trac/xsl/trac.xsl /tmp/svn.xml >> /tmp/update-trac-tickets.log 
if [ "$?" != "0" ]; then
   echo "xsltproc failed" >> /tmp/update-trac-tickets.log 
   exit 1;
fi
cat /tmp/trac.sql | sqlite /data/development/trac/clientstep/db/trac.db >> /tmp/update-trac-tickets.log 2>&1
if [ "$?" != "0" ]; then
   echo "sqlite failed" >> /tmp/update-trac-tickets.log 
   exit 1;
fi
