<?xml version="1.0" encoding="UTF-8"?>
<stylesheet version="1.0" xmlns="http://www.w3.org/1999/XSL/Transform">
  <strip-space elements="*"/>
  <output method="xml" encoding="UTF-8" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>

  <!--
      Processes a set of log entries, one ticket number at a time, calls
      it self recursively with the remaining set to gradually go through 
      each ticket number in the set.
      @param log A set of svn logentry objects.
  -->
  <template name="oneticket">
    <param name="log"/>
    <if test="count($log)>0">
      <variable name="ticket" select="$log[1]/msg/@ticket"/>
      <text>DELETE FROM ticket_change WHERE author='trac' AND time=946684800 AND ticket=</text>
      <value-of select="$ticket"/>
      <text>;
INSERT INTO ticket_change VALUES ('</text>
      <value-of select="$ticket"/>
      <text>',946684800,'trac','comment','',"</text>
      <for-each select="$log[msg/@ticket=$ticket]">	
	<sort data-type="number" order="descending" select="@revision"/>
	<text>||[</text>
	<value-of select="@revision"/>
	<text>]||</text>
	<value-of select="author"/>
	<text>||</text>
	<value-of select="substring-before(date,'T')"/>
	<text> </text>
	<value-of select="substring-after(substring-before(date,'.'),'T')"/>
	<text>||</text>
	<value-of select="translate(normalize-space(msg),'&quot;',&quot;&apos;&quot;)"/>
	<text>||
</text>
      </for-each>
      <text>");
</text>
      <call-template name="oneticket">
	<with-param name="log" select="$log[msg/@ticket!=$ticket]"/>
      </call-template>
    </if>
  </template>

  <!--
      MAIN TEMPLATE, processes all log entries, output SQL for sqlite database.
      Processes svn log in xml format to produce a comment on each ticket
      listing all changesets associated with that ticket.
      @author Philip Bergen
  
      USAGE: 
        svn log svn://svn | sed 's/<msg\(.*\)#\([0-9]*\)/<msg ticket="\2"\1#\2/' > /tmp/svn.xml;
	xsltproc -o /tmp/trac.sql trac.xsl /tmp/svn.xml
	cat /tmp/trac.sql | sqlite /data/development/trac/clientstep/db/trac.db
  -->
  <template match="/">
    <text>BEGIN TRANSACTION;

</text>
    <call-template name="oneticket">
      <with-param name="log" select="log/logentry[msg/@ticket>$minticket]"/>
    </call-template>
    <text>END TRANSACTION;
</text>
  </template>
<template match="text()"></template>
</stylesheet>
