# $Id: Makefile.PL,v 1.1 2007/03/23 16:12:58 joern Exp $

use strict;
use ExtUtils::MakeMaker;

my $loop_modules = 0;
my $has_event    = 0;
my $has_glib     = 0;

eval { require Event; $has_event = 1 } && ++$loop_modules;
eval { require Glib;  $has_glib  = 1 } && ++$loop_modules;

if ( !$loop_modules ) {
    print "\n";
    print "***************************************************************\n";
    print "WARNING: You need Event or Glib for Video::TranscodeRC to work!\n";
    print "***************************************************************\n";
    print "\n";
}

#-- Add found modules to PREREQ_PM, so CPAN Testers add
#-- version numbers of these modules to the reports, which
#-- are very important in case of failing tests.
my @add_prereq;
push @add_prereq, 'Event', 0           if $has_event;
push @add_prereq, 'Glib', 0            if $has_glib;

WriteMakefile(
    'NAME'	   => 'Video::TranscodeRC',
    'VERSION_FROM' => 'lib/Video/TranscodeRC.pm',
    'EXE_FILES'    => [ 'bin/transcode-rc' ],
    'PREREQ_PM'    => {
        @add_prereq,
    },
    'dist' => {
        COMPRESS => "gzip",
        SUFFIX   => "gz",
	PREOP    => q[pod2text lib/Video/TranscodeRC.pm > README],
	POSTOP	 => q[mkdir -p dist && mv Video-TranscodeRC-*tar.gz dist/],
    },
);
