package org.apache.turbine;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Turbine" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import com.meterware.httpunit.WebTable;
import com.meterware.httpunit.WebResponse;

import org.apache.cactus.ServletTestCase;
import org.apache.cactus.WebRequest;

/**
 * This is the testing servlet for the Turbine core
 * classes. Subsystems like Torque and Fulcrum are not
 * tested here.
 *
 * @author <a href="mailto:jeff.Brekke@qg.com">Jeff Brekke</a>
 * @author <a href="mailto:jvanzyl@zenplex.com">Jason van Zyl</a>
 * @version $Id: TurbineServletTest.java,v 1.5 2002/01/23 04:35:59 brekke Exp $
 */
public class TurbineServletTest
    extends ServletTestCase
{
    /**
     * Core Turbine servlet used for testing.
     */
    Turbine turbine;

    /**
     * Default Constructor.
     */
    public TurbineServletTest(String name)
    {
        super(name);
    }

    /**
     * Default test suite for this test case.
     */
    public static Test suite()
    {
        return new TestSuite(TurbineServletTest.class);
    }

    /**
     * This setup will be running server side.  We startup Turbine and
     * get our test port from the properties.  This gets run before
     * each testXXX test.
     */
    protected void setUp()
        throws Exception
    {
        super.setUp();
        config.setInitParameter("properties",
                "/WEB-INF/conf/TurbineResources.properties");
        turbine = new Turbine();
        turbine.init(config);
    }

    /**
     * After each testXXX test runs, shut down the Turbine servlet.
     */
    protected void tearDown()
        throws Exception
    {
        turbine.destroy();
        super.tearDown();
    }

    /**
     * This begin runs client side before the testHompage test runs. 
     * We'll set up our simualated url here.
     */
    public void beginHomepage(WebRequest theRequest)
    {
        theRequest.setURL(null, "/test", "/servlet/test", null, null);
    }

    /**
     * Run our actual test.  Here we just call the doGet on the
     * servlet.
     */
    public void testHomepage()
        throws Exception
    {
        turbine.doGet(request, response);
    }

    /**
     * Check the response from our test using HttpUnit.
     */
    public void endHomepage(WebResponse theResponse)
        throws Exception
    {
        // Verify the Title
        assertEquals("Test Application", theResponse.getTitle());

        // Verify the layout
        WebTable table = theResponse.getTableWithID("layout");
        assertNotNull("Table: layout was not found.", table);
        assertEquals("Incorrect number of rows in layout table.",
                3, table.getRowCount());
        assertEquals("Incorrect number of columns in layout table.",
                1, table.getColumnCount());

        assertEquals("Turbine Test App",
                table.getTableCellWithID("topNav").asText().trim());
        assertEquals("Powered By Turbine!",
                table.getTableCellWithID("bottomNav").asText().trim());
        assertEquals("Please stand by, This is only a test.",
                table.getTableCellWithID("screen").asText().trim());
    }

    /**
     * Setup our request url to attempt to load a bogus action
     * which will cause Turbine to render the Error.vm.
     */
    public void beginErrorTemplate(WebRequest theRequest)
    {
        theRequest.setURL(null, "/test", "/servlet/test",
                "/action/NoSuchAction", null);
    }

    /**
     * Call the doGet on the servlet
     */
    public void testErrorTemplate()
        throws Exception
    {
        turbine.doGet(request, response);
    }

    /**
     * Check our response with HttpUnit.  This will be the Error.vm
     * template with our exception.
     */
    public void endErrorTemplate(WebResponse theResponse)
        throws Exception
    {
        // Verify the Title
        assertEquals("Test Application", theResponse.getTitle());

        // Verify the error table
        WebTable table = theResponse.getTableWithID("error");
        assertNotNull("Table: error was not found.", table);
        assertEquals("Incorrect number of rows in error table.", 2,
                table.getRowCount());
        assertEquals("Incorrect number of columns in error table.", 1,
                table.getColumnCount());

        assertEquals("Error", table.getCellAsText(0, 0).trim());
        assertTrue("No exception or stack trace?",
                table.getCellAsText(1, 0).trim().length() > 0);
    }
    
    /**
     * This begin runs client side before the testHompage test runs. 
     * We'll set up our simualated url here.
     */
    public void beginJspPage(WebRequest theRequest)
    {
        theRequest.setURL(null, "/test", "/servlet/test", 
                          "/template/Index.jsp", null);
    }

    /**
     * Run our actual test.  Here we just call the doGet on the
     * servlet.
     */
    public void testJspPage()
        throws Exception
    {
        turbine.doGet(request, response);
    }

    /**
     * Check the response from our test using HttpUnit.
     */
    public void endJspPage(WebResponse theResponse)
        throws Exception
    {
        assertEquals("Test Application", theResponse.getTitle());
    }
}
