from turbogears import widgets

template = """
    <div xmlns:py="http://purl.org/kid/ns#">
    <?python
    book = value['value']['book']
    item = value['value']['item']
    ?>
    $book $item
    </div>
"""


class TestObj(object):
    book = "im a book"
    def __repr__(self): 
        return self.__class__.__name__

    
class InlineWidget(widgets.SimpleWidget):
    def __call__(self, obj):
        value = dict(value=dict(book=obj.book, item=obj))
        # changed to render to print to screen
        return self.render(value)


def test_template_as_string():
    w = InlineWidget(template=template)
    output = w(TestObj())
    print output
    assert "im a book" in  output
    assert "TestObj" in  output

def test_template_as_a_file():
    f = open('templates/test_template.kid', 'w')
    print >> f, template
    f.close()
    w = InlineWidget(template="templates.test_template")
    output = w(TestObj())
    print output
    assert "im a book" in  output
    assert "TestObj" in  output

if __name__ == '__main__':
    test_template_as_string()
    test_template_as_string()

