/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.formmodel.interactive.hypo;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.RenderingHints.Key;
import java.util.Map;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;

import com.ulcjava.base.shared.ErrorObject;

public class HypoErrorOverlay extends JComponent {
    private final UIHypoErrorManager fErrorManager;
    
    public HypoErrorOverlay(UIHypoErrorManager errorManager) {
        fErrorManager = errorManager;
    }
    
    @Override
    protected void paintComponent(Graphics g) {
        
        for (JComponent widget : fErrorManager.getErrorByWidget().keySet()) {
            Point errorIconLocation = new Point();
            SwingUtilities.convertPointToScreen(errorIconLocation, widget);
            SwingUtilities.convertPointFromScreen(errorIconLocation, this);

            Graphics2D g2 = (Graphics2D)g.create();
            g2.translate(errorIconLocation.x, errorIconLocation.y);
            g2.translate(0, widget.getHeight());
            g2.scale(0.75, 0.75);
            g2.translate(0, -fErrorManager.getErrorIcon().getBasicIcon().getIconHeight());
            
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.drawImage(fErrorManager.getErrorIcon().getBasicIcon().getImage(), 0, 0, null);
            
            g2.dispose();
        }
    }
}
