/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.formmodel.interactive.hypo;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class HypoErrorOverlayLayoutManager implements LayoutManager {
    public void addLayoutComponent(String name, Component comp) {
    }
    
    public void layoutContainer(Container parent) {
        JRootPane rootPane = SwingUtilities.getRootPane(parent);
        for (Component component : parent.getComponents()) {
            if (component instanceof HypoErrorOverlay) {
                HypoErrorOverlay hypoErrorOverlay = (HypoErrorOverlay)component;
                hypoErrorOverlay.setSize(rootPane.getContentPane().getSize());
            }
        }
    }
    
    public Dimension minimumLayoutSize(Container parent) {
        return parent.getParent().getLayout().minimumLayoutSize(parent.getParent());
    }
    
    public Dimension preferredLayoutSize(Container parent) {
        return parent.getParent().getLayout().preferredLayoutSize(parent.getParent());
    }
    
    public void removeLayoutComponent(Component comp) {
    }
}
