/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.formmodel.interactive.hypo;


import com.ulcjava.applicationframework.application.form.AbstractFormBuilder;
import com.ulcjava.applicationframework.application.form.LabelParameter;
import com.ulcjava.applicationframework.application.form.TextFieldParameter;
import com.ulcjava.base.application.ULCLabel;
import com.ulcjava.base.application.datatype.ULCAbstractErrorManager;
import com.ulcjava.base.application.util.ULCIcon;

public class HypoForm extends AbstractFormBuilder<HypoFormModel> {
    
    public HypoForm(HypoFormModel bean) {
        super(bean);
    }
    
    @Override
    protected void initForm() {
        setColumnWeights(0, 1, 1, 1, 1);
        setLabelHorizontalAlignment(ULCLabel.TRAILING);
        
        addAmountTextField(HypoBean.OBJECTPRICE).endColumn(2);
        addAmountTextField(HypoBean.EIGENMITTEL).endColumn(2);
        addAmountTextField(HypoBean.OBJECTVALUE).endColumn(2);
        
        addStyledTitle("financingTitle");
        addLabel("amount").startNewRow(true).startColumn(1);
        addLabel("interestRate").startColumn(2);
        addLabel("annualInterest").startColumn(3);
        addLabel("monthlyInterest").startColumn(4);
        
        addLabel("loan1");
        addAmountTextField(HypoBean.FINANCING1_LOANAMOUNT).startColumn(1).noLabel(true);
        addPercentTextField(HypoBean.FINANCING1_INTERESTRATE).startColumn(2).noLabel(true);
        addAmountTextField(HypoBean.FINANCING1_ANNUALINTEREST).startColumn(3).noLabel(true);
        addAmountTextField(HypoBean.FINANCING1_MONTHLYINTEREST).startColumn(4).noLabel(true);
        
        addLabel("loan2");
        addAmountTextField(HypoBean.FINANCING2_LOANAMOUNT).startColumn(1).noLabel(true);
        addPercentTextField(HypoBean.FINANCING2_INTERESTRATE).startColumn(2).noLabel(true);
        addAmountTextField(HypoBean.FINANCING2_ANNUALINTEREST).startColumn(3).noLabel(true);
        addAmountTextField(HypoBean.FINANCING2_MONTHLYINTEREST).startColumn(4).noLabel(true);
        
        addLabel("total");
        addAmountTextField(HypoBean.LOANAMOUNT).startColumn(1).endColumn(2).noLabel(true);
        addAmountTextField(HypoBean.ANNUALINTEREST).startColumn(3).noLabel(true);
        addAmountTextField(HypoBean.MONTHLYINTEREST).startColumn(4).noLabel(true);
        
        addStyledTitle("amortizeTitle");
        addLabel("amount").startNewRow(true).startColumn(1);
        addLabel("years").startColumn(2);
        addLabel("annualAmortisation").startColumn(3);
        addLabel("monthlyAmortisation").startColumn(4);
        
        addLabel("amortize");
        addAmountTextField(HypoBean.AMORTISATIONAMOUNT).startColumn(1).noLabel(true);
        addTextField(HypoBean.AMORTISATIONYEARS).startColumn(2).noLabel(true).columns(5);
        addAmountTextField(HypoBean.YEARLYAMORTISATIONAMOUNT).startColumn(3).noLabel(true);
        addAmountTextField("monthlyAmortisationAmmount").startColumn(4).noLabel(true);
        
        addStyledTitle("feasibilityTitle");
        addLabel("annualCosts").startColumn(3);
        addLabel("monthlyCosts").startColumn(4);
        
        addLabel("totalCosts").endColumn(1);
        addAmountTextField(HypoBean.ANNUALCOSTS).startColumn(3).noLabel(true);
        addAmountTextField(HypoBean.MONTHLYCOSTS).startColumn(4).noLabel(true);
    }
    
    protected TextFieldParameter addPercentTextField(String propertyName) {
        return addTextField(propertyName).style("Percent");
    }
    
    protected TextFieldParameter addAmountTextField(String propertyName) {
        return addTextField(propertyName).style("Amount");
    }
    
    protected LabelParameter addStyledTitle(String titleText) {
        return addTitle(titleText).style("Title");
    }
    
    @Override
    protected ULCAbstractErrorManager createErrorManager() {
        ULCIcon errorIcon = getResourceMap().getULCIcon("errorIcon");
        String defaultMessage = getResourceMap().getString("defaultMessage");
        
        return new ULCHypoErrorManager(createErrorMessages(), errorIcon, defaultMessage, this);
    }
    
}
