/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.formmodel.interactive.hypo;

import com.ulcjava.base.client.UIComponent;
import com.ulcjava.base.client.UIIcon;
import com.ulcjava.base.client.datatype.IErrorVisualizer;
import com.ulcjava.base.client.datatype.UIAbstractErrorManager;
import com.ulcjava.base.shared.ErrorObject;

import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class UIHypoErrorManager extends UIAbstractErrorManager {
    private final Map<JComponent, ErrorObject> fErrorByWidget;
    
    private UIIcon fErrorIcon;
    private String fDefaultMessage;
    private UIComponent fFormPane;
    
    public UIHypoErrorManager() {
        fErrorByWidget = new LinkedHashMap<JComponent, ErrorObject>();
    }
    
    public UIIcon getErrorIcon() {
        return fErrorIcon;
    }
    
    public void setErrorIcon(UIIcon errorIcon) {
        fErrorIcon = errorIcon;
    }
    
    public String getDefaultMessage() {
        return fDefaultMessage;
    }
    
    public void setDefaultMessage(String defaultMessage) {
        fDefaultMessage = defaultMessage;
    }
    
    
    public UIComponent getFormPane() {
        return fFormPane;
    }
    
    public void setFormPane(UIComponent errorPane) {
        fFormPane = errorPane;
    }
    
    public Map<JComponent, ErrorObject> getErrorByWidget() {
        return fErrorByWidget;
    }
    
    @Override
    public void showError(JComponent widget, ErrorObject error) {
        // remove always to guarantee order in linked hash map
        fErrorByWidget.remove(widget);
        
        if (error != null) {
            fErrorByWidget.put(widget, error);
        }
        
        Iterator<Entry<JComponent, ErrorObject>> entries = fErrorByWidget.entrySet().iterator();
        if (entries.hasNext()) {
            Entry<JComponent, ErrorObject> relevantEntry = entries.next();
            while (entries.hasNext()) {
                relevantEntry = entries.next();
            }
            
            JComponent relevantWidget = relevantEntry.getKey();
            JLabel relevantLabel = (JLabel)relevantWidget.getClientProperty("labeledBy");
            ErrorObject relevantError = relevantEntry.getValue();
            
            StringBuilder message = new StringBuilder();
            if (relevantLabel != null) {
                message.append(relevantLabel.getText()).append(": ");
            }
            message.append(getLocalizedMessage(relevantError));
            
            getMessageLabel().setIcon(fErrorIcon.getBasicIcon());
            getMessageLabel().setText(message.toString());
        } else {
            getMessageLabel().setIcon(null);
            getMessageLabel().setText(fDefaultMessage);
        }
        
        JRootPane rootPane = SwingUtilities.getRootPane(fFormPane.getBasicComponent());
        if (rootPane.getLayeredPane().getLayout() == null) {
            rootPane.getLayeredPane().setLayout(new HypoErrorOverlayLayoutManager());
            rootPane.getLayeredPane().add(new HypoErrorOverlay(this), JLayeredPane.PALETTE_LAYER);
        }
        
        widget.revalidate();
        widget.repaint();
    }
    
    private JLabel getMessageLabel() {
        return getMessageLabel(SwingUtilities.getRootPane(fFormPane.getBasicComponent()));
    }
    
    private static JLabel getMessageLabel(Component component) {
        if ("message.Label".equals(component.getName())) {
            return (JLabel)component;
        }
        
        if (component instanceof Container) {
            Container container = (Container)component;
            
            for (Component child : container.getComponents()) {
                Component result = getMessageLabel(child);
                if (result != null) {
                    return (JLabel)result;
                }
            }
        }
        
        return null;
    }
    
    protected IErrorVisualizer createVisualizer(JComponent widget, ErrorObject error) {
        return null;
    }
    
}
