/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.formmodel.interactive.hypo;

import com.ulcjava.applicationframework.application.form.AbstractFormBuilder;
import com.ulcjava.base.application.datatype.ULCAbstractErrorManager;
import com.ulcjava.base.application.util.ULCIcon;

import java.util.Map;

public class ULCHypoErrorManager extends ULCAbstractErrorManager {
    private final ULCIcon fErrorIcon;
    private final String fDefaultMessage;
    private final AbstractFormBuilder<?> fFormBuilder;
    
    public ULCHypoErrorManager(Map<?, ?> errorMessages, ULCIcon errorIcon, String defaultMessage, AbstractFormBuilder<?> formBuilder) {
        super(errorMessages);
        fErrorIcon = errorIcon;
        fDefaultMessage = defaultMessage;
        fFormBuilder = formBuilder;
    }
    
    @Override
    protected void uploadStateUI() {
        super.uploadStateUI();
        setStateUI("errorIcon", fErrorIcon);
        setStateUI("defaultMessage", fDefaultMessage);
        setStateUI("formPane", fFormBuilder.getFormPane());
    }
    
    @Override
    protected String typeString() {
        return UIHypoErrorManager.class.getName();
    }
}