/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.avro;

import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.test.evolution.Kind;
import org.apache.avro.test.evolution.*;
import org.apache.avro.util.Utf8;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.List;
import java.util.ArrayList;
import java.util.HashSet;


public class SimpleServer {

    public static void main(String args[]) throws Exception {
        setupServer();
        Thread.sleep(200000);
        tearDownServer();
    }





  static SimpleServer svr ;
  // client's proxy, assuming the new param structure, but server does not use the new proto
  static Evolution proxy;

  public static final int SERVER_PORT = 10000;

  static public void setupServer() throws Exception {

    // note here that we create the server using old protocol "Evolution",
    // but the client is created using protocol "Evolution"
    svr = new SimpleServer();
    svr.startServer();

    Transceiver client;
    client = new SocketTransceiver(new InetSocketAddress(SERVER_PORT));
    SpecificRequestor req = new SpecificRequestor(Evolution.class, client);
    proxy = SpecificRequestor.getClient(Evolution.class, (SpecificRequestor)req);

  }


  static public void tearDownServer() throws Exception {

    svr.stopServer();
  }







  public static class TestImpl implements Evolution  {
    public TestRecord echo(TestRecord record) { System.out.println("Got record" + record.kind ); return record; }
    //public org.apache.avro.test.evolution.Kind oneWayEcho(TestRecord record) { return org.apache.avro.test.evolution.Kind.BAZ; }
    public Kind oneWayEcho(TestRecord record) { return Kind.BAZ; }
  }

  protected static Server server;

  protected static SpecificResponder responder;


  public void startServer() throws Exception {
    responder = new SpecificResponder(Evolution.class, new TestImpl());
    server = createServer(responder);
    server.start();
    
  }

  public void stopServer() throws Exception {
   server.close();
  }
  
  public Server createServer(Responder testResponder) throws Exception{
    return server = new SocketServer(testResponder,
                              new InetSocketAddress(SERVER_PORT));   
  }



  

}
  
  
  


