/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.avro;

import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.test.evolution.Kind;
import org.apache.avro.test.evolution.*;
import org.apache.avro.util.Utf8;
import org.junit.After;
import org.junit.Test;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.AfterClass;
import static org.junit.Assert.assertTrue;

import static org.junit.Assert.*;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.List;
import java.util.ArrayList;
import java.util.HashSet;


public class TestSimpleClient {

  // client's proxy, assuming the new param structure, but server does not use the new proto
  static Evolution proxy;

  public static final int SERVER_PORT = 10000;

  @BeforeClass 
  public static void setupConnection() throws Exception {
    Transceiver client;
    client = new SocketTransceiver(new InetSocketAddress(SERVER_PORT));
    SpecificRequestor req = new SpecificRequestor(Evolution.class, client);
    proxy = SpecificRequestor.getClient(Evolution.class, (SpecificRequestor)req);

  }


  @Test
  public void testClientSameReturnType() throws Exception {

    
    TestRecord record = new TestRecord();
    record.name = new Utf8("foo");
    record.extra_field = new Utf8("extra");
    record.kind = Kind.BAR;

    TestRecord record2 = new TestRecord();
    record2.name = new Utf8("foo");     
    record2.kind = Kind.BAR;
    
    // input param is different, but return has to be the same 
    // to keep "signature" consistent
    Kind ret = proxy.oneWayEcho(record);
    assertEquals("should return 0", Kind.BAZ, ret);
 }



  @Test//(expected=ClassCastException.class)
  public void testClientDiffReturnType() throws Exception {

    
    TestRecord record = new TestRecord();
    record.name = new Utf8("foo");
    record.extra_field = new Utf8("extra");
    record.kind = Kind.BAR;

    TestRecord record2 = new TestRecord();
    record2.name = new Utf8("foo");     
    record2.kind = Kind.BAR;

    // should fail here, cuz the server returns a evolution2.TestRecord, which contains only 2 fields
    // since signature changed, this is not a valid use case
    TestRecord echoed = proxy.echo(record);
 }


}
  
  
  


