package sample;

import java.io.IOException;

import javax.xml.transform.stream.StreamSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.support.AbstractMarshaller;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@ContextConfiguration(locations = { "classpath:ctx/applicationContext.xml" })
public class SampleTest extends AbstractTestNGSpringContextTests {

	@Autowired
	private AbstractMarshaller marshaller;
	
	@Value("classpath:xml/sample.xml")
	private Resource sampleXml;
	
	public void sampleTest() throws XmlMappingException, IOException {
		Object obj = marshaller.unmarshal(new StreamSource(sampleXml.getInputStream()));
		
		Assert.assertTrue(obj instanceof Test_bean);
		
		Test_bean aBean = (Test_bean)obj;
		Emp emp = aBean.getEmp();
		
		Assert.assertNotNull(emp);
		
		Assert.assertEquals(emp.getId(), 123);
		Assert.assertEquals(emp.getContent(), "Mister Jones");
	}
}
