package com.example.geode;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.gemfire.config.annotation.CacheServerApplication;
import org.springframework.data.gemfire.config.annotation.EnableEntityDefinedRegions;
import org.springframework.data.gemfire.config.annotation.EnableLocator;
import org.springframework.data.gemfire.config.annotation.EnablePdx;
import org.springframework.data.gemfire.repository.config.EnableGemfireRepositories;
import org.springframework.data.gemfire.transaction.config.EnableGemfireCacheTransactions;

@SpringBootApplication
@CacheServerApplication(name="SampleServer",copyOnRead=true,logLevel="info")
@EnableLocator
@EnablePdx(readSerialized=true)
@EnableEntityDefinedRegions(basePackages="com.example.geode.model")
@EnableGemfireRepositories(basePackages="com.example.geode.repo")
@EnableGemfireCacheTransactions

public class Main {
	public static void main(String[] args) throws Exception {
		SpringApplication.run(Main.class, args);
	}

}
