package com.example.geode;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.geode.pdx.JSONFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import com.example.geode.model.Customer;
import com.example.geode.service.CustomerService;

@Component
public class SimpleApplicationListener implements ApplicationListener<ContextRefreshedEvent> {

	@Autowired
	CustomerService service;

	@SuppressWarnings("unchecked")
	@Override
	public void onApplicationEvent(ContextRefreshedEvent event) {

		String json1 = "{ \"cid\" : \"1234\", \"name\" : \"A1\", \"address\" : \"India\"}";

		service.saveCustomer1(new Customer("1234", JSONFormatter.fromJSON(json1)));
		
		// Let's create 2 callables and try to update same copy of customer
		
		// Update address from A1 to A2
		Callable<String> t1 = new Callable<String>() {

			@Override
			public String call() throws Exception {
				service.updateCustomer("1234","A2");
				return "T1 Done";
			}
		};
		
		// Update address from A1 to A3
		Callable<String> t2 = new Callable<String>() {

			@Override
			public String call() throws Exception {
				service.updateCustomer("1234","A3");
				return "T2 Done";
			}
		};
		
		ExecutorService executorService2 = Executors.newFixedThreadPool(2);
		
		
		try {
			executorService2.invokeAll((Collection) Arrays.asList(t1,t2));
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		// Wait for main thread to finish
		try {
			System.out.println("Main thread is going to wait for 5 seconds...");
			Thread.sleep(5000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		System.out.println("Main thread is going to shutdown pool...");
		executorService2.shutdown();
	}

}
