package com.example.geode.model;

import org.apache.geode.pdx.PdxInstance;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.gemfire.mapping.annotation.ReplicateRegion;

@ReplicateRegion("Customers")
public class Customer {
	@Id
	private String cid;
	private PdxInstance details;
	
	public Customer() {
	}
	
	@PersistenceConstructor
	public Customer(String cid, PdxInstance details) {
		super();
		this.cid = cid;
		this.details = details;
	}

	public String getCid() {
		return cid;
	}

	public void setCid(String cid) {
		this.cid = cid;
	}

	public PdxInstance getDetails() {
		return details;
	}

	public void setDetails(PdxInstance details) {
		this.details = details;
	}

}
