/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package eu.mibesis.test.jms.war;

import java.io.IOException;

import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @Version $Rev: 677701 $ $Date: 2008-07-17 21:48:20 +0200 (čet, 17 jul 2008) $
 */
public class OrderSenderServlet extends HttpServlet {

    /**
	 * 
	 */
	private static final long serialVersionUID = -3309414419208794665L;

	@Resource(name = "OrderConnectionFactory")
    private ConnectionFactory factory;

    @Resource(name = "OrderQueue")
    private Queue receivingQueue;

    @Override
    public void init() throws ServletException {
        super.init();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        manageOrders(req, res);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        doGet(req, res);
    }

    private void manageOrders(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = "/error.jsp";
        Connection connection = null;
        MessageProducer messageProducer = null;
        Session sess = null;
        try {
            String customerId = req.getParameter("customerId");
            String orderId = req.getParameter("orderId");
            String qty = req.getParameter("quantity");
            String model = req.getParameter("model");

            if (!customerId.equals("") && !orderId.equals("") && !qty.equals("")) {
                System.out.println("(client) Start Sending Order Request");
                path = "/order.jsp";

                connection = factory.createConnection();
                sess = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
                TextMessage msg = sess.createTextMessage("<CustomerId=" + customerId + " OrderId=" + orderId
                        + " Quantity=" + qty + " Model=" + model + ">");
                messageProducer = sess.createProducer(receivingQueue);
                messageProducer.send(msg);
                System.out.println("(client) Order Request Sent");
            } else {
                String error = "";

                if (customerId.equals("")) {
                    error = "Customer Id cannot be empty";
                } else if (orderId.equals("")) {
                    error = "Order Id cannot be empty";
                } else if (qty.equals("")) {
                    error = "Quantity cannot be empty";
                }
                req.setAttribute("error", error);
            }
        }
        catch (Exception e) {
            System.out.println("Error " + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (messageProducer != null) messageProducer.close();
                if (sess != null) sess.close();
                if (connection != null) connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        getServletContext().getRequestDispatcher(path).forward(req, res);
    }
}
