<?xml version="1.0" encoding="UTF-8" ?>
<!--
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at
  
  http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

<!-- $Id: page2xhtml.xsl 498802 2007-01-22 21:11:57Z nettings $ -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns:page="http://apache.org/cocoon/lenya/cms-page/1.0"
  xmlns:lenya="http://apache.org/cocoon/lenya/page-envelope/1.0" 
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
  exclude-result-prefixes="page xhtml dc lenya"
  >
  
  <!-- {context-prefix}/{publication-id}/{area} -->
  <xsl:param name="root"/>
  <xsl:param name="context-prefix"/>
  
  <!-- i.e. doctypes/xhtml-document -->
  <xsl:param name="document-type"/>
  
  <xsl:param name="document-path"/>
  
  <!-- The request url i.e. /lenya/doctypes/xhtml-document_en.html -->
  <xsl:param name="url"/>
  <xsl:param name="language"/>
  <xsl:param name="title"/>
  
  <xsl:param name="lastPublishedUser"/>
  <xsl:param name="lastPublishedDate"/>
  
  <!--Following is a show off to explain lenya.properties.xml -->
  <xsl:param name="author"/>
  
  <xsl:template match="cmsbody">
    <xsl:variable name="parent">
      <xsl:value-of select="substring-before(substring-after($document-path,'/'),'/')"/>
    </xsl:variable>

    <html>
      <head>
        <link rel="neutron-introspection" type="application/neutron+xml" href="{$root}{$document-path}/introspection.xml"/>
        <link rel="stylesheet" href="{$root}/css/fair-solution.css" type="text/css"/>
        <xsl:choose>
          <xsl:when test="$document-type">
            <!-- Looking into the pub e.g. {$yourPub}/resources/shared/css/{$document-type}.css -->
            <link rel="stylesheet" href="{$root}/css/{$document-type}.css" type="text/css"/>
            <xsl:copy-of select="xhtml:html/xhtml:head/*"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
        <meta content="Apache Lenya" name="generator"/>
        <title><xsl:value-of select="$title"/></title>
        <meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8"/>
      </head>
      <body>
        <div id="container">
        <div id="logo">
          <span id="fairsolution" title="fair solution Event- und Messemanagement: Wir setzen Sie in Szene.">
            <span id="fair">fair</span> 
            <span id="solution">solution</span>
          </span>
          <span id="EuMm">Event- und Messemanagement</span>
        </div>
        <div id="header">
          <span id="claim"><i18n:text key="fairsolution-claim"/></span>
          <!-- ! -->
          <xsl:choose>
            <xsl:when test="$parent">
              <img id="impression" src="{$root}/{$parent}/bild-oben.jpg" alt=""/>
            </xsl:when>
            <xsl:otherwise>
              <img id="impression" src="{$root}{$document-path}/bild-oben.jpg" alt=""/>
            </xsl:otherwise>
          </xsl:choose>
        </div>
        <hr id="horizontal"/>
        <div id="sidebar">
          <xsl:apply-templates select="xhtml:ul[@id = 'nav']"/>
          <xsl:choose>
            <xsl:when test="$parent">
              <img id="bar" src="{$root}/{$parent}/bild-unten.jpg" alt=""/>
            </xsl:when>
            <xsl:otherwise>
              <img id="bar" src="{$root}{$document-path}/bild-unten.jpg" alt=""/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:apply-templates select="xhtml:div[@id = 'languageselector']"/>
        </div>
        <hr id="vertical"/>
        <div id="content">
          <xsl:apply-templates select="xhtml:div[@id = 'body']"/>
          <xsl:if test="xhtml:html">
            <xsl:apply-templates select="xhtml:html/xhtml:body/*"/>
          </xsl:if>
        </div>
      </div>
    </body>
  </html>
</xsl:template>

<xsl:template match="xhtml:div[@id = 'languageselector']">
  <ul id="lang">
    <xsl:for-each select=".//xhtml:a">
      <li><xsl:copy-of select="."/></li>
    </xsl:for-each>
  </ul>
</xsl:template>
<xsl:template match="@*|node()" priority="-1">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

  
</xsl:stylesheet> 
