package ops.opejb;

import javax.rmi.*;
import javax.naming.*;
import java.util.*;

public class OpossumClient {

 public static void main( String args[]) {
  try{
    
    Properties p = new Properties();
    
    //The JNDI properties you set depend
    //on which server you are using.
    //These properties are for the Remote Server.
    p.put("java.naming.factory.initial", "org.openejb.client.LocalInitialContextFactory");
    p.put("openejb.home", "/home/kapi/openejb-0.9.2");   
    
    //Now use those properties to create
    //a JNDI InitialContext with the server.
    InitialContext ctx = new InitialContext( p );
    
    //Lookup the bean using it's deployment id
    Object obj = ctx.lookup("/Opossum");
    
    //Be good and use RMI remote object narrowing
    //as required by the EJB specification.
    OpossumHome ejbHome = (OpossumHome)
        PortableRemoteObject.narrow(obj,OpossumHome.class);

    //Use the HelloHome to create a HelloObject
    OpossumObject ejbObject = ejbHome.create();
    
    //The part we've all been wainting for...
    String message = ejbObject.sayHello();
    String resultado = ejbObject.ejecutar();
    //A drum roll please.
    System.out.println( message );
    System.out.println( resultado );
    
  } catch (Exception e){
    e.printStackTrace();
  }
 }
}