package artemis.simple.consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.jms.Message;
import jakarta.jms.MessageListener;

public class MessageLogger implements MessageListener {

    private static final String MESSAGE_ID_PROPERTY = "messageId";
    private static final String MESSAGE_CONTENT_PROPERTY = "content";

    private static final Logger LOG = LoggerFactory.getLogger(MessageLogger.class);
    private final int port;

    private int lastMessageId = 0;
    private int sequenceErrors = 0;

    public MessageLogger(final int port) {
        this.port = port;
    }

    @Override
    public void onMessage(final Message message) {
        try {
            final int currentMessageId = message.getIntProperty(MESSAGE_ID_PROPERTY);

            if (lastMessageId != 0 && lastMessageId + 1 != currentMessageId) {
                sequenceErrors++;
                LOG.info("Order mismatch: expected {}, got {}, total {}", lastMessageId + 1,
                        currentMessageId, sequenceErrors);
            } else {
//                LOG.info("Consume msg #{} on port {}: {} (e:{})", currentMessageId, port,
//                        message.getStringProperty(MESSAGE_CONTENT_PROPERTY), sequenceErrors);
            }
            lastMessageId = currentMessageId;

        } catch (final Exception e) {
            LOG.error("Error consuming message from port {}", port, e.toString(), e);
        }
    }
}