package artemis.simple.consumer;

import org.apache.qpid.jms.JmsConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;

public class SimpleConsumer {

    private static final Logger LOG = LoggerFactory.getLogger(SimpleConsumer.class);

    private static final int PORT_BASE = 5670;
    private static final String PORT_INCREMENT_PROPERTY = "portIncrement";
    private static final String topicName = "topic";

    private int port;
    private JmsConnectionFactory jmsConnectionFactory;

    public void startConsumer() throws JMSException, JMSException {
        port = PORT_BASE + Integer.valueOf(System.getProperty(PORT_INCREMENT_PROPERTY));
        LOG.info("Starting consumer on port {}", port);

        jmsConnectionFactory = new JmsConnectionFactory("amqp://localhost:" + port);
        final Connection connection = jmsConnectionFactory.createConnection();
        connection.start();

        final Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
        final MessageConsumer consumer = session.createConsumer(session.createTopic(topicName));

        consumer.setMessageListener(new MessageLogger(port));

    }

    public static void main(final String[] args) throws JMSException {
        final SimpleConsumer c = new SimpleConsumer();
        c.startConsumer();
    }
}
