#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <linux/if_ether.h>
#include <linux/if_packet.h>
#include <net/if.h>


/* Frame (47 bytes) */
static const unsigned char pkt3[47] = {
0x02, 0x42, 0xc0, 0xa8, 0x02, 0x01, 0x02, 0x42, /* .B.....B */
0xc0, 0xa8, 0x02, 0x05, 0x08, 0x00, 0x45, 0x00, /* ......E. */
0x00, 0x21, 0xbb, 0xa1, 0x40, 0x00, 0x40, 0x11, /* .!..@.@. */
0xf9, 0xd3, 0xc0, 0xa8, 0x02, 0x05, 0xc0, 0xa8, /* ........ */
0x02, 0x01, 0x17, 0x6e, 0x17, 0x6d, 0x00, 0x0d, /* ...n.m.. */
0x85, 0x75, 0x6f, 0x6b, 0x31, 0x0d, 0x0a        /* .uok1.. */
};

struct sockaddr_ll socket_address;

#define MY_DEST_MAC0    0x02
#define MY_DEST_MAC1    0x42
#define MY_DEST_MAC2    0xc0
#define MY_DEST_MAC3    0xa8
#define MY_DEST_MAC4    0x02
#define MY_DEST_MAC5    0x01

static const char *device_name;
static int fanout_type;
static int fanout_id;
#ifndef PACKET_FANOUT
# define PACKET_FANOUT			18
# define PACKET_FANOUT_HASH		0
# define PACKET_FANOUT_LB		1
#endif
static int setup_socket(void)
{
    int err, fd = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
    struct sockaddr_ll ll;
    struct ifreq ifr;
    int fanout_arg;
    if (fd < 0) {
	    perror("socket");
	    return EXIT_FAILURE;
    }
    memset(&ifr, 0, sizeof(ifr));
    strcpy(ifr.ifr_name, device_name);
    err = ioctl(fd, SIOCGIFINDEX, &ifr);
    if (err < 0) {
	    perror("SIOCGIFINDEX");
	    return EXIT_FAILURE;
    }
    memset(&ll, 0, sizeof(ll));
    ll.sll_family = AF_PACKET;
    ll.sll_ifindex = ifr.ifr_ifindex;
    err = bind(fd, (struct sockaddr *) &ll, sizeof(ll));
    if (err < 0) {
	    perror("bind");
	    return EXIT_FAILURE;
    }
    /*fanout_arg = (fanout_id | (fanout_type << 16));
    err = setsockopt(fd, SOL_PACKET, PACKET_FANOUT,
		    &fanout_arg, sizeof(fanout_arg));
    if (err) {
	    perror("setsockopt");
	    return EXIT_FAILURE;
    }*/


	memset(&socket_address, 0, sizeof(socket_address));
	/* Index of the network device */
	socket_address.sll_ifindex = ifr.ifr_ifindex;
	/* Address length*/
	socket_address.sll_halen = ETH_ALEN;
	socket_address.sll_family = AF_PACKET;
	socket_address.sll_protocol  = ETH_P_ALL;

	/* Destination MAC */
	socket_address.sll_addr[0] = MY_DEST_MAC0;
	socket_address.sll_addr[1] = MY_DEST_MAC1;
	socket_address.sll_addr[2] = MY_DEST_MAC2;
	socket_address.sll_addr[3] = MY_DEST_MAC3;
	socket_address.sll_addr[4] = MY_DEST_MAC4;
	socket_address.sll_addr[5] = MY_DEST_MAC5;
    
    return fd;
}
static void fanout_thread(void)
{
    int fd = setup_socket();
    int limit = 10000;
    if (fd < 0)
	    exit(fd);
    while (limit-- > 0) {
	    char buf[1600];
	    int err;
	    err = read(fd, buf, sizeof(buf));
	    if (err < 0) {
		    perror("read");
		    exit(EXIT_FAILURE);
	    }
        fprintf(stdout, "Got packet size:(%d) \n", sizeof(buf));
	    if ((limit % 10) == 0)
		    fprintf(stdout, "(%d) \n", getpid());
    }
    fprintf(stdout, "%d: Received 10000 packets\n", getpid());
    close(fd);
    exit(0);
}


static void send_thread(void)
{
 	int fd = setup_socket();
    int limit = 5;
    if (fd < 0)
	    exit(fd);
		
	while (limit-- > 0) {
	    /* Send packet */
		if (sendto(fd, pkt3, sizeof(pkt3), 0, (struct sockaddr*)&socket_address, sizeof(struct sockaddr_ll)) < 0){
		    perror("sendto");
		    exit(EXIT_FAILURE);
	    }

		printf("sent packet\n");
		sleep(1);

    }
	close(fd);
    exit(0);
}

int main(int argc, char **argp)
{
    int fd, err;
    int i;
    if (argc != 3) {
	    fprintf(stderr, "Usage: %s INTERFACE {hash|lb}\n", argp[0]);
	    return EXIT_FAILURE;
    }
    if (!strcmp(argp[2], "hash"))
	    fanout_type = PACKET_FANOUT_HASH;
    else if (!strcmp(argp[2], "lb"))
	    fanout_type = PACKET_FANOUT_LB;
    else {
	    fprintf(stderr, "Unknown fanout type [%s]\n", argp[2]);
	    exit(EXIT_FAILURE);
    }
    device_name = argp[1];
    fanout_id = getpid() & 0xffff;
    for (i = 0; i < 1; i++) {
	    pid_t pid = fork();
	    switch (pid) {
	    case 0:
		    //fanout_thread();
			send_thread();
	    case -1:
		    perror("fork");
		    exit(EXIT_FAILURE);
	    }
    }
    for (i = 0; i < 4; i++) {
	    int status;
	    wait(&status);
    }
    return 0;
}   