! this file contains routines to do matrix operations

!***********************************************************************************

! routine that does element by element mat [*] mat
subroutine mat_mul_mat( matsize, mat_1, mat_2, mat_3 )

  implicit none
  
  ! matsize is the size of mat_x
  ! the first two matrixes are input, while the third is output
  integer(kind=4), dimension(3), intent(in) :: matsize
  real(kind=8), dimension(matsize(1),matsize(2),matsize(3)), intent(in) :: mat_1, mat_2
  real(kind=8), dimension(matsize(1),matsize(2),matsize(3)), intent(out) :: mat_3
  ! loop counters
  integer(kind=4) :: i, j, k
  
  forall( i=1:matsize(1), j=1:matsize(2), k=1:matsize(3) )
    mat_3(i,j,k) = mat_1(i,j,k) * mat_2(i,j,k)
  end forall

end subroutine mat_mul_mat

!***********************************************************************************

! routine that calculates volume from given vectors
subroutine calc_volume( a, volume )

  implicit none
  
  ! a is a 3*3 matrix containing vectors
  real(kind=8), dimension(3,3), intent(in) :: a
  real(kind=8), intent(out) :: volume
  ! internal vars
  real(kind=8), dimension(3) :: a_1, a_2, a_3, temp
  
  a_1 = a(1,:)
  a_2 = a(2,:)
  a_3 = a(3,:)
  
  call cross_product( a_1, a_2, temp )
  volume = dot_product( temp, a_3 )

end subroutine calc_volume

!***********************************************************************************

! routine that does cross_product
subroutine cross_product( x, y, z )
  implicit none
  real(kind=8), dimension(3), intent(in)  :: x
  real(kind=8), dimension(3), intent(in)  :: y
  real(kind=8), dimension(3), intent(out) :: z
  
  z(1) = x(2) * y(3) - x(3) * y(2)
  z(2) = x(3) * y(1) - x(1) * y(3)
  z(3) = x(1) * y(2) - x(2) * y(1)
  
end subroutine cross_product
