#include <stdexcept>
#include <cerrno>
#include <sys/types.h>

#include <wait.h>
#include <signal.h> 
#include <string.h>
#include <unistd.h>

#include "QpidBroker.h"

QpidBroker::QpidBroker(const std::string& options):
   pid_(0),
   path_("/home/clive/work/qpid/install/qpid-0.28/sbin/qpidd"),
   options_(options)
{

}

void QpidBroker::setPath(const std::string& path)
{
   path_ = path;
}

void QpidBroker::start (const uint32_t timeout)
{
  pid_t child = fork();
  switch(child){
    case -1 : // ERROR
	       throw std::runtime_error(std::string("QpidBroker::start : fork failed ") + strerror(errno));
	       break;
     
     case 0  : // the child
		if(execl(path_.c_str(),path_.c_str(),options_.c_str(),NULL) == -1){
		  throw std::runtime_error(std::string("Qpidbroker::start : execl failed") + strerror(errno));
		}
		break;
    
    
    default: // the parent
             pid_ = child;
	     sleep(timeout);  // give child time to settle before returning
	     break;
  
  }
}

void QpidBroker::stop  (const uint32_t  timeout)
{
  // Basic stop behaviour, not the best but O.K for an aid to testing
  if(pid_ > 0){
      kill(pid_,SIGTERM);
      kill(pid_,SIGKILL);
      sleep(1); // give time for signal delivery and broker shutdown.
      
      uint32_t waited = 0;
      while(waited++ < timeout){
         int status = 0;
	 pid_t wait = waitpid(pid_,&status,WNOHANG);
	 if(wait == -1){
	    throw std::runtime_error(std::string("QpidBroker::stop : waitpid failed ")  + strerror(errno));
	 }
	 else if (wait == pid_){
	   pid_ = 0;
	   break;
	 }
	 sleep(1);
      }
      
      if (pid_ != 0){
	 throw std::runtime_error("QpidBroker::stop : child process termination failed ");
      }
   }
}
