### replicate_semaphore_behavior ###

This is an RTEMS application for reproducing a bad behavior of a binary semaphore used to synchronize SW functions.

##### Context: #####

The original project where this behavior was observed uses custom HW accelerators as co-processors. At some point, an RTEMS task delegates the execution to the HW accelerators and it is suspended until the execution finishes.

The semaphore tested is used for avoiding different RTEMS tasks to request things to the HW co-processors at the same time.

##### SW functions #####

+ test_init: emulates the initialization of the HW infrastructure and creates the synchronization semaphore object

+ test_load_kernel: emulates a dynamic partial configuration of a new HW accelerator in the FPGA by wasting time. A DPR cannot be performed while the co-processors are being used.

+ test_execute_kernel: emulates the execution in HW by sleeping the thread. This task would command an HW execution and enter in sleep mode until the HW finishes

#### ouputs ####

Logs obtained running the test in the Zedboard development board

task 1 start  
ld adq by kernel. kern_1  
ld rel by kernel. kern_1  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
task 2 start  
exe rel by kernel: kern_1  
ld adq by kernel. kern_2    //**semaphore adquired by task 2**  
exe adq by kernel: kern_1   //**semaphore adquired by task 1 before it has been released**  
sleeping kernel : kern_1  
ld rel by kernel. kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
...  

Logs obtained running the test in the zcu102 development board (BSP not already available in the RTEMS project)

task 1 start  
ld adq by kernel. kern_1  
ld rel by kernel. kern_1  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
task 2 start  
exe rel by kernel: kern_1  
ld adq by kernel. kern_2  //**semaphore adquired by task 2**  
exe adq by kernel: kern_1  //**semaphore adquired by task 1 before it has been released**  
sleeping kernel : kern_1  
ld rel by kernel. kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
exe adq by kernel: kern_1  
sleeping kernel : kern_1  
exe rel by kernel: kern_2  
exe rel by kernel: kern_1  
exe adq by kernel: kern_2  
sleeping kernel : kern_2  
...
