/*
 *  Classic API Hello World
 */

#include <rtems.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>

#include "src.h"

rtems_name task_1_name;
rtems_id   task_1_id;
rtems_name task_2_name;
rtems_id   task_2_id;

rtems_task task_1_task(rtems_task_argument ignored);
rtems_task task_2_task(rtems_task_argument ignored);

rtems_task task_1(rtems_task_argument ignored)
{
	printf("task 1 start\n");

	test_load_kernel("kern_1");

	while(1) {
		test_execute_kernel("kern_1", 1);
	}

	rtems_task_delete(RTEMS_SELF);
}

rtems_task task_2(rtems_task_argument ignored)
{
	printf("task 2 start\n");

	test_load_kernel("kern_2");

	while(1) {
		test_execute_kernel("kern_2", 2);
	}

	rtems_task_delete(RTEMS_SELF);
}

rtems_task Init( rtems_task_argument ignored )
{
	rtems_status_code status;
	task_1_name = rtems_build_name( 'T', 'A', '1', ' ' );
	task_2_name = rtems_build_name( 'T', 'A', '2', ' ' );

	test_init();

	test_create_kernel("kern_1");
	test_create_kernel("kern_2");

	status = rtems_task_create(
	task_1_name, 1, RTEMS_MINIMUM_STACK_SIZE * 2, RTEMS_PREEMPT,
	RTEMS_LOCAL, &task_1_id
	);
	if ( status != 0 ) {
	  printf( "rtems_task_create failed with status of %s.\n", rtems_status_text(status) );
	}

	status = rtems_task_create(
		task_2_name, 2, RTEMS_MINIMUM_STACK_SIZE * 2, RTEMS_PREEMPT,
		RTEMS_LOCAL, &task_2_id
	);
	if ( status != 0 ) {
		printf( "rtems_task_create failed with status of %s.\n", rtems_status_text(status) );
	}

	status = rtems_task_start( task_1_id, task_1, 1 );
	if ( status != 0 ) {
    printf( "rtems_task_start failed with status of %s.\n", rtems_status_text(status) );
  }

	status = rtems_task_start( task_2_id, task_2, 1 );
	if ( status != 0 ) {
		printf( "rtems_task_start failed with status of %s.\n", rtems_status_text(status) );
	}

  rtems_task_delete(RTEMS_SELF);
}

/* configuration information */
/* NOTICE: the clock driver is explicitly disabled */
#define CONFIGURE_APPLICATION_NEEDS_CLOCK_DRIVER
#define CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER

#define CONFIGURE_RTEMS_INIT_TASKS_TABLE
#define CONFIGURE_MAXIMUM_TASKS 4

#define CONFIGURE_INIT_TASK_STACK_SIZE    (2 * RTEMS_MINIMUM_STACK_SIZE)

#define CONFIGURE_EXTRA_TASK_STACKS       (4 * RTEMS_MINIMUM_STACK_SIZE)

#define CONFIGURE_INIT
#include <rtems/confdefs.h>
/* end of file */
