#include <stdio.h>
#include <stdlib.h>

#include "src.h"

/*Thread syncronization semaphore*/
static rtems_name sync_name;
static rtems_id sync_id;

static volatile int running;

static struct kernel_t **kernels = NULL;


/*
 * @brief: initialize kernel array and create sync sem object
 *
 * @return: 0 on sucess 1 on error
 */
int test_init(){
  rtems_status_code sc;
	int i;

	// Initialize kernel list
	kernels = malloc(MAXKERNS * sizeof **kernels);
	if (!kernels) {
		printf("malloc() failed\n");
		return 1;
	}
	for (i = 0; i < MAXKERNS; i++) {
		kernels[i] = NULL;
	}

	sync_name = rtems_build_name('S', 'Y', 'S', 'M');
  sc = rtems_semaphore_create(sync_name, 1,
		RTEMS_BINARY_SEMAPHORE | RTEMS_PRIORITY | RTEMS_LOCAL, 0, &sync_id);
	if (sc != RTEMS_SUCCESSFUL) {
		printf("Error creating sync semaphore: %s\n", rtems_status_text(sc));
		return 1;
	}

	return 0;
}

/*
 * @brief: allocate memory for kernel object and insert it into kernels array
 *
 * @return: 0 on sucess 1 on error
 */
int test_create_kernel(const char *name) {
	unsigned int index;
	struct kernel_t *kernel = NULL;

	// Search for kernel in kernel list
	for (index = 0; index < MAXKERNS; index++) {
		if (kernels[index] == NULL) break;
	}
	if (index == MAXKERNS) {
		printf("kernel list is already full\n");
		return 1;
	}

	// Allocate memory for kernel info
	kernel = malloc(sizeof *kernel);
	if (!kernel) {
		printf("malloc() failed\n");
		return 1;
	}

	// Set kernel name
	kernel->name = malloc(strlen(name) + 1);
	if (!kernel->name) {
		printf("malloc() failed\n");
		return 1;
	}
	strcpy(kernel->name, name);

	kernels[index] = kernel;

	return 0;
}

/*
 * @brief: emulates the load of a new HW acc by waiting time.
 *
 * @return: 0 on sucess 1 on error
 */
int test_load_kernel(const char *name) {
	unsigned int index;
	volatile int cont;
	rtems_status_code sc;

	// Search for kernel in kernel list
	for (index = 0; index < MAXKERNS; index++) {
		if (kernels[index] == NULL) break;
	}
	if (index == MAXKERNS) {
		printf("kernel list is already full\n");
		return 1;
	}

	while(1) {
		sc = rtems_semaphore_obtain(sync_id, RTEMS_DEFAULT_OPTIONS, RTEMS_NO_TIMEOUT);
		if( sc != RTEMS_SUCCESSFUL) {
        printf("error obtaining sync semaphore with sc:%s\n", rtems_status_text(sc));
    } else {
			test_print("ld adq by kernel. %s\n", name);
		}

		// Only change configuration when no kernel is being executed
		if(!running) {
			for (cont = 0; cont < MAX_CONT; cont++) {
				cont++;
			}
			break;
		}

		sc = rtems_semaphore_release(sync_id);
		if( sc != RTEMS_SUCCESSFUL) {
				printf("2 error obtaining a3k semaphore with sc:%s\n", rtems_status_text(sc));
		} else {
			test_print("ld rel by kernel. %s\n", name);
		}
	}
	sc = rtems_semaphore_release(sync_id);
	if( sc != RTEMS_SUCCESSFUL) {
			printf("2 error obtaining a3k semaphore with sc:%s\n", rtems_status_text(sc));
	} else {
		test_print("ld rel by kernel. %s\n", name);
	}

	return 0;
}

/*
 * @brief: emulates the execution in HW by sleeping the thread. This task would
 * 				 command a HW execution and enter in sleep mode until the HW finishes
 *
 * @return: 0 on sucess 1 on error
 */
int test_execute_kernel(const char *name, int ticks) {
	unsigned int index;
	int iter = 0;
	rtems_status_code sc;

	// Search for kernel in kernel list
	for (index = 0; index < MAXKERNS; index++) {
		if (!kernels[index]) continue;
		if (strcmp(kernels[index]->name, name) == 0) break;
	}
	if (index == MAXKERNS) {
		printf("no kernel found with name %s\n", name);
		return 1;
	}

	while (iter < ITERS) {
		sc = rtems_semaphore_obtain(sync_id, RTEMS_DEFAULT_OPTIONS, RTEMS_NO_TIMEOUT);
		if( sc != RTEMS_SUCCESSFUL) {
        printf("error obtaining sync semaphore with sc:%s\n", rtems_status_text(sc));
    } else {
			test_print("exe adq by kernel: %s\n", name);
		}

		running = 1;

		test_print("sleeping kernel : %s\n", name);
		rtems_task_wake_after(ticks);


		running = 0;

		sc = rtems_semaphore_release(sync_id);
		if( sc != RTEMS_SUCCESSFUL) {
				printf("error releasing sync semaphore with sc:%s\n", rtems_status_text(sc));
		} else {
			test_print("exe rel by kernel: %s\n", name);
		}

	}

	return 0;
}
