#include "rtems.h"

#define MAXKERNS (0xF)
#define ITERS 0xF
#define MAX_CONT 10000

#ifndef TEST_PRINT
#define TEST_PRINT 1
#endif

#if TEST_PRINT
#define test_print(msg, args...) printf(msg, ##args)
#else
#define test_print(msg, args...)
#endif

struct kernel_t {
    char *name;
};

/*
 * @brief: initialize kernel array and creates sync sem object
 *
 * @return: 0 on sucess 1 on error
 */
int test_init();

/*
 * @brief: allocate memory for kernel object and insert it into kernels array
 *
 * @return: 0 on sucess 1 on error
 */
int test_create_kernel(const char *name);

/*
 * @brief: emulates the load of a new HW acc by waiting time.
 *
 * @return: 0 on sucess 1 on error
 */
int test_load_kernel(const char *name) ;

/*
 * @brief: emulates the execution in HW by sleeping the thread. This task would
 * 				 command a HW execution and enter in sleep mode until the HW finishes
 *
 * @return: 0 on sucess 1 on error
 */
int test_execute_kernel(const char *name, int exec_time) ;
