#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <malloc.h>
#include <signal.h>
#include <execinfo.h>
#include <sys/utsname.h>


const uint32_t gdmpVersion = 1;
char * programName = NULL, * programVersion = "1.2.3";


typedef void (*SignalHandler)(void);


void errorHandler(int sig)
{
	static sig_atomic_t allreadyRunning = 0;

	if (allreadyRunning)
		raise(sig);
	allreadyRunning = 1;

	void * btBuffer[128];
	struct utsname sysInfo;
	uint32_t btSize = backtrace(btBuffer, 128), signum = sig, validUname = (uname(&sysInfo) == 0), programNameSize = strlen(programName), programVersionSize = strlen(programVersion);
	uint32_t sizeOfVoidP = sizeof(void*), sizeOfUtsname = sizeof(struct utsname), sizeOfChar = sizeof(char);

	FILE * dumpFile = fopen("mdump.gdmp", "w");
	
	fwrite(&gdmpVersion, sizeof(uint32_t), 1, dumpFile);

	fwrite(&sizeOfChar, sizeof(uint32_t), 1, dumpFile);
	fwrite(&sizeOfVoidP, sizeof(uint32_t), 1, dumpFile);
	fwrite(&sizeOfUtsname, sizeof(uint32_t), 1, dumpFile);

	fwrite(&validUname, sizeof(uint32_t), 1, dumpFile);
	fwrite(&sysInfo, sizeOfUtsname, 1, dumpFile);

	fwrite(&programNameSize, sizeof(uint32_t), 1, dumpFile);
	fwrite(programName, sizeOfChar, programNameSize, dumpFile);
	fwrite(&programVersionSize, sizeof(uint32_t), 1, dumpFile);
	fwrite(programVersion, sizeOfChar, programVersionSize, dumpFile);

	fwrite(&signum, sizeof(uint32_t), 1, dumpFile);

	fwrite(&btSize, sizeof(uint32_t), 1, dumpFile);
	fwrite(&btBuffer, sizeOfVoidP, btSize, dumpFile);

	fclose(dumpFile);

	signal(sig, SIG_DFL);
	raise(sig);
}


void setErrorHandler(SignalHander)
{
	if (signal(SIGFPE, errorHandler) == SIG_IGN)
		signal(SIGFPE, SIG_IGN);
	if (signal(SIGFPE, errorHandler) == SIG_IGN)
		signal(SIGFPE, SIG_IGN);
	if (signal(SIGILL, errorHandler) == SIG_IGN)
		signal(SIGILL, SIG_IGN);
	if (signal(SIGSEGV, errorHandler) == SIG_IGN)
		signal(SIGSEGV, SIG_IGN);
	if (signal(SIGBUS, errorHandler) == SIG_IGN)
		signal(SIGBUS, SIG_IGN);
	if (signal(SIGABRT, errorHandler) == SIG_IGN)
		signal(SIGABRT, SIG_IGN);
	if (signal(SIGTRAP, errorHandler) == SIG_IGN)
		signal(SIGTRAP, SIG_IGN);
	if (signal(SIGSYS, errorHandler) == SIG_IGN)
		signal(SIGSYS, SIG_IGN);
}


void except(void)
{
	*(int*)NULL = 0x0;
}


int main(int argc, char * argv[])
{
	programName = argv[0];
	setErrorHandler(errorHandler);
	except();
	return 0;
}
