#include <QtGui/QGuiApplication>
#include "qtquick2applicationviewer.h"

#include <QQmlContext>
#include <QQmlProperty>

#include <QDebug>

int main(int argc, char *argv[])
{
    QGuiApplication app(argc, argv);

    QtQuick2ApplicationViewer viewer;

    viewer.setResizeMode(QQuickView::SizeRootObjectToView);

    viewer.setMainQmlFile(QStringLiteral("qml/SimpleWebAppRunner/main.qml"));

    // Select the app to load
    QQmlProperty property((QObject*)(viewer.rootObject()), "appToLoad");
    property.write("SimpleWebApp");

    viewer.showExpanded();

    return app.exec();
}
