// Generated by the WOLips Templateengine Plug-in at Jun 17, 2008 8:00:41 AM
package your.app.components;

import your.app.eo.TestBug;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGlobalID;

public class Main extends WOComponent {
	private static final long serialVersionUID = 1L;

	public Main(WOContext context) {
		super(context);
		ec = new EOEditingContext();
		ec.lock();
		try{
			eo = new TestBug();
			ec.insertObject(eo);
			eo.setValue("Initial Value");
			ec.saveChanges();
		}finally{
			ec.unlock();
		}

	}
	
	private TestBug eo;
	private EOEditingContext ec;
	
	public String currentValue(){ 
		ec.lock();
		try{
			return eo.value();
		}finally{
			ec.unlock();
		}
	}
	
	public String currentThreadName(){
		return Thread.currentThread().getName();
	}
	
	public String originalUnsavedChangesThreadName = null;
	
	public boolean haveDoneOriginalUnsavedChange(){
		return originalUnsavedChangesThreadName != null;
	}
	
	public boolean haveUnsavedChanges(){
		ec.lock();
		try{
			return ec.hasChanges();
		}finally{
			ec.unlock();
		}
	}
	
	public WOComponent doOriginalChange(){
		ec.lock();
		try{
			eo.setValue(currentThreadName());
			originalUnsavedChangesThreadName = currentThreadName();
		}finally{
			ec.unlock();
		}
		return null;
	}
	
	public WOComponent saveChanges(){
		try{
			ec.lock();
			ec.saveChanges();
		}finally{
			ec.unlock();
		}
		
		if ( currentThreadName().equals( originalUnsavedChangesThreadName))
			error = "The save changes occurred in the same thread as the original change, "
				+ "so this demonstration will not work.  Make sure you run this application through "
				+ "your web server, not direct connect so that the threads will cycle.";
		return null;
	}
	
	public WOComponent doChangeAndSave(){
		
		ec.lock();
		try{
			eo.setValue(currentThreadName());
			ec.saveChanges();
		}finally{
			ec.unlock();
		}
		return null;
	}
	public String currentDatabaseValue(){
		EOGlobalID gid = null;
		ec.lock();
		try{
			gid = ec.globalIDForObject(eo);
			
		}finally{
			ec.unlock();
		}
		EOEditingContext nec = new EOEditingContext();
		nec.lock();
		try{
			TestBug tb = (TestBug)nec.faultForGlobalID(gid, nec);
			return tb.value();
		}finally{
			nec.unlock();
		}
	}
	
	public String error = null;
	public boolean haveError(){ return error != null; }
	
	public boolean amBackToOriginalThread(){
		return currentThreadName().equals(originalUnsavedChangesThreadName) && _appending;
	}
	
	public boolean demonstrationDidSucceed(){
		return ! currentValue().equals(currentDatabaseValue());
	}

	private boolean _appending = false;
	@Override
	public void appendToResponse(WOResponse arg0, WOContext arg1) {
		_appending = true;
		try{
			super.appendToResponse(arg0, arg1);
		}finally{
			_appending = false;
		}
	}
	
}
