/*
 *  An example of using EOF without WebObjects
 */

import java.lang.*;

import java.io.*;
import java.net.*;
import java.util.*;
import com.webobjects.foundation.*;
import com.webobjects.eoaccess.*;
import com.webobjects.eocontrol.*;

public class Example {
    public static void main(String args[]){
		  // initialize models
		  File model1Path = new File("Movies.eomodeld");
		  File model2Path = new File("Rentals.eomodeld");

		  URL model1URL = null;
		  URL model2URL = null;
		  try {
				model1URL = model1Path.toURL();
				model2URL = model2Path.toURL();
		  } catch (MalformedURLException e) {}

		  EOModelGroup.defaultGroup().addModelWithPathURL(model1URL);
		  EOModelGroup.defaultGroup().addModelWithPathURL(model2URL);


		  // fetch
		  EOQualifier q = EOQualifier.qualifierWithQualifierFormat("title like '*'", new NSArray());
		  EOFetchSpecification fs = new EOFetchSpecification("Movie", q, null);
		  fs.setFetchLimit(3);
		  EOEditingContext ec = new EOEditingContext();
		  NSArray objects = ec.objectsWithFetchSpecification(fs);

		  // display inspection of the objects
		  Enumeration e = objects.objectEnumerator();
		  while (e.hasMoreElements()) {
				EOEnterpriseObject eo = (EOEnterpriseObject)e.nextElement();
				System.out.println(eo.toString());
		  }

    }

}

