
#include <Wt/WApplication>

#include <Wt/WGridLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WContainerWidget>

#include <Wt/WBreak>
#include <Wt/WText>

class App: public Wt::WApplication
{
  public:
    Wt::WWidget* content()
    {
      Wt::WVBoxLayout* l = new Wt::WVBoxLayout();
      for( int i = 0; i < 100; i += 1 )
      {
        l->addWidget( new Wt::WText( Wt::WString( "Row {1}" ).arg( i + 1 ) ) );
      }

      Wt::WContainerWidget* res = new Wt::WContainerWidget();
      res->setStyleClass( "Content" );
      res->setLayout( l );

      return res;
    }

    Wt::WWidget* top()
    {
      Wt::WContainerWidget* res = new Wt::WContainerWidget;
      res->setStyleClass( "top" );
      res->resize( Wt::WLength::Auto, 120 );

      return res;
    }
    Wt::WWidget* left()
    {
      Wt::WContainerWidget* res = new Wt::WContainerWidget;
      res->setStyleClass( "left" );
      res->resize( 100, Wt::WLength::Auto );

      return res;
    }
    Wt::WWidget* right()
    {
      Wt::WContainerWidget* res = new Wt::WContainerWidget;
      res->setStyleClass( "right" );
      res->setOverflow( Wt::WContainerWidget::OverflowAuto );
      res->addWidget( content() );

      return res;
    }

    App( Wt::WEnvironment const& env ):
      Wt::WApplication( env )
    {
      useStyleSheet( "style.css" );

      Wt::WGridLayout* grid = new Wt::WGridLayout();

      grid->addWidget( top(), 0, 0, 1, 2 );
      grid->addWidget( left(), 1, 0 );
      Wt::WVBoxLayout* l = new Wt::WVBoxLayout();
      l->addWidget( right() );
      grid->addLayout( l, 1, 1 );

      grid->setColumnStretch( 1, 1 );
      grid->setRowStretch( 1, 1 );
      grid->setVerticalSpacing( 0 );
      grid->setHorizontalSpacing( 0 );
      grid->setContentsMargins( 0, 0, 0, 0 );

      root()->setLayout( grid );
    }
};

Wt::WApplication* createApp( Wt::WEnvironment const& env )
{
  return new App( env );
}

int main( int argc, char** argv )
{
  return Wt::WRun( argc, argv, &createApp );
}

