
#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WPushButton>
#include <Wt/WTable>
#include <Wt/WText>

bool workingExample = false;
bool initialContent = false;

class App: public Wt::WApplication
{
  private:
    Wt::WTable* table;
  public:

    void addRow()
    {
      int rowIdx = table->rowCount();

      if( workingExample )
      {
        table->insertRow( rowIdx );
      }
      table->elementAt( rowIdx, 0 )->
        addWidget( new Wt::WText( Wt::WString( "{1}, 0" ).arg( rowIdx ) ) );

      table->rowAt( rowIdx )->setStyleClass( "bg" );
    }

    App( Wt::WEnvironment const& env ):
      Wt::WApplication( env )
    {
      useStyleSheet( "style.css" );

      Wt::WPushButton* btn = new Wt::WPushButton( "Add row" );
      btn->clicked().connect( this, &App::addRow );

      root()->addWidget( btn );
      root()->addWidget( new Wt::WBreak() );

      table = new Wt::WTable();
      root()->addWidget( table );

      if( initialContent )
      {
        for( int i = 0; i < 5; ++i )
        {
          table->elementAt( i, 0 )->
            addWidget( new Wt::WText( Wt::WString( "{1}, 0" ).arg( i ) ) );
          Wt::WTableRow* row = table->rowAt( i );
          row->setStyleClass( "bg" );
        }
      }
    }
};

Wt::WApplication* createApp( Wt::WEnvironment const& env )
{
  return new App( env );
}

int main( int argc, char** argv )
{
  return Wt::WRun( argc, argv, &createApp );
}

