#include "externalpanel.h"
#include <Wt/WGridLayout>
#include <Wt/WContainerWidget>
#include <Wt/WComboBox>

ExternalPanel::ExternalPanel(Wt::WContainerWidget* const aParent)
    : Wt::WPanel(aParent),
      theCentralBody(new Wt::WContainerWidget),
      theComboBox(new Wt::WComboBox(theCentralBody)),
      theButton(new Wt::WPushButton("BUTTON", theCentralBody)),
      thePanel(new InternalPanel)
{
  setTitle("External Panel");
  setCollapsible(true);
  setMaximumSize(410, Wt::WLength::Auto);

  setCentralWidget(theCentralBody);

  Wt::WGridLayout* const myGridLayout(new Wt::WGridLayout());
  theCentralBody->setLayout(myGridLayout/*, Wt::AlignTop | Wt::AlignLeft*/);

  myGridLayout->addWidget(theComboBox, 0, 0);
  myGridLayout->addWidget(theButton,   0, 1);
  myGridLayout->addWidget(thePanel,   2, 0, 1, 2);
}

ExternalPanel::~ExternalPanel() {

}


