#include "externalpanel.h"
#include <Wt/WContainerWidget>
#include <Wt/WGridLayout>

InternalPanel::InternalPanel(Wt::WContainerWidget* const aParent)
    : Wt::WPanel(aParent),
      theButton1(new Wt::WPushButton("BUTTON 1")),
      theButton2(new Wt::WPushButton("BUTTON 2"))
{
  setTitle("Internal Panel");
  setCollapsible(true);
  setMaximumSize(410, Wt::WLength::Auto);

  Wt::WContainerWidget* myCentralBody = new Wt::WContainerWidget;
  setCentralWidget(myCentralBody);

  Wt::WGridLayout* const myGridLayout(new Wt::WGridLayout);
  myCentralBody->setLayout(myGridLayout);

  myGridLayout->addWidget(theButton1, 0, 0);
  myGridLayout->addWidget(theButton2, 0, 1);
}

InternalPanel::~InternalPanel() {

}


