package com.test;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import javax.ejb.*;
import java.util.Collection;
import java.util.Vector;
import java.util.Iterator;

/*
 * This is a user bean. Each user of the application has one user bean
 * representing his account in the application.
 * 
 * @see UserRoleBean Every user has one or more user role
 * settings. Each user role provides access to certain sections of the
 * application.
 *
 * @ejb:bean
 *   name="BlahBlahTest"
 *   jndi-name="testApp/UserTest"
 *   type="CMP"
 *   primkey-field="id"
 * @ejb:finder signature="Collection findAll()"
 * @ejb:pk class="java.lang.Integer"
 * @ejb:env-entry name="blabla" value="12345" type="java.lang.Integer"
 *
 */

public abstract class UserBean implements EntityBean {
	EntityContext ctx;

	/**
	 * Create instance of User. Note that this method returns null
	 * because the real creation is managed by the EJB container. Both
	 * id and username must be unique in the table storing the user
	 * entities. They should both have unique constraints in the
	 * database, so an attempt to store a bean with a non-unique id will
	 * result in a DuplicateKeyException. An attempt to store a bean
	 * with a non-unique username will result in a CreateException.
	 *
	 * @param _id the id of the user.
	 * @param _username the username of the user.
	 * @return null.
	 *
	 * @ejb:create-method
	 **/
	public Integer ejbCreate(Integer _id, String _username)
		throws CreateException {
		setId(_id);
		setUsername(_username);
		return null;
	}

	// Called when the object has been instantiated; does nothing here.
	public void ejbPostCreate(Integer _id, String _username) {}

	/*
	 * @ejb:interface-method
	 * @ejb:persistent-field
	 * @ejb:persistence column-name="id"
	 * @ejb:pk-field
	 */
	public abstract Integer getId();
	// this field should be considered read-only. EJB 2.0 requires the mutator.
	public abstract void setId(Integer _id);

	/*
	 * @ejb:interface-method
	 * @ejb:persistent-field
	 * @ejb:persistence column-name="username"
	 */
	public abstract String getUsername();
	// this field should be considered read-only. EJB 2.0 requires the mutator.
	public abstract void setUsername(String _username);

	/*
	 * @ejb:interface-method
	 * @ejb:persistent-field
	 * @ejb:persistence column-name="password"
	 */
	public abstract String getPassword();
	public abstract void setPassword(String _password);

	/*
	 * @ejb:interface-method
	 * @ejb:persistent-field
	 * @ejb:persistence column-name="creation_date"
	 */
	public abstract Timestamp getCreationDate();
	// this field should be considered read-only. EJB 2.0 requires the mutator.
	public abstract void setCreationDate(Timestamp _creationDate);

	// EJB callback methods
	public void setEntityContext(EntityContext ctx) {
		this.ctx=ctx;
	}
	public void unsetEntityContext() {
		ctx = null;
	}
	public void ejbActivate() {}
	public void ejbPassivate() {}
	public void ejbLoad() {
	}
	public void ejbStore() {
	}
	public void ejbRemove() {}
}
